/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.loading;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.loading.ILoadingService;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.loading.LoadingNode;

public class LoadingNodeDoubleKeyCollection {
    private Map collection = new HashMap();

    public boolean containsKey(Object parent, ILoadingService loadingService) {
        boolean containsKey = false;
        for (DoubleKey key : this.collection.keySet()) {
            if (key.getParent() != parent || key.getLoadingService() != loadingService) continue;
            containsKey = true;
            break;
        }
        return containsKey;
    }

    public void put(Object parent, ILoadingService loadingService, Object node) {
        this.collection.put(new DoubleKey(parent, loadingService), node);
    }

    public ILoadingService queryLoadingService(Object parent, LoadingNode placeHolder) {
        ILoadingService loadingService = null;
        for (DoubleKey key : this.collection.keySet()) {
            if (key.getParent() != parent || this.collection.get(key) != placeHolder) continue;
            loadingService = key.getLoadingService();
        }
        return loadingService;
    }

    public void remove(Object parent, ILoadingService loadingService) {
        for (DoubleKey key : this.collection.keySet()) {
            if (key.getParent() != parent || key.getLoadingService() != loadingService) continue;
            this.collection.remove(key);
            break;
        }
    }

    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    private class DoubleKey {
        Object parent;
        ILoadingService loadingService;

        public DoubleKey(Object parent, ILoadingService loadingService) {
            this.parent = parent;
            this.loadingService = loadingService;
        }

        public void setParent(Object parent) {
            this.parent = parent;
        }

        public void setLoadingService(ILoadingService loadingService) {
            this.loadingService = loadingService;
        }

        public Object getParent() {
            return this.parent;
        }

        public ILoadingService getLoadingService() {
            return this.loadingService;
        }
    }
}

