/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors;

import java.util.ArrayList;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors.DelegateProcessor;

public class TagCompletionProcessor
extends DelegateProcessor {
    private String[] tags = new String[]{"locations", "location", "target", "unit", "repository", "targetJRE"};
    private String prefix;
    private int offset;

    public TagCompletionProcessor(String prefix, String acKey, int offset) {
        this.prefix = prefix;
        this.offset = offset;
    }

    @Override
    public ICompletionProposal[] getCompletionProposals() {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        int i = 0;
        while (i < this.tags.length) {
            if (this.tags[i].startsWith(this.prefix)) {
                String handyAddition;
                String proposal = "";
                if (this.tags[i].equalsIgnoreCase("unit") || this.tags[i].equalsIgnoreCase("repository")) {
                    handyAddition = "/>";
                    proposal = String.valueOf(this.tags[i]) + handyAddition;
                } else {
                    handyAddition = "</" + this.tags[i] + ">";
                    proposal = String.valueOf(this.tags[i]) + ">" + handyAddition;
                }
                proposals.add(new CompletionProposal(proposal, this.offset - this.prefix.length(), this.prefix.length(), proposal.length() - handyAddition.length(), null, this.tags[i], null, null));
            }
            ++i;
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }
}

