/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.parts.core;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jwt.meta.model.core.NamedElement;
import org.eclipse.jwt.we.figures.core.NamedElementFigure;
import org.eclipse.jwt.we.parts.core.NodeModelElementEditPart;
import org.eclipse.jwt.we.parts.core.directEdit.NamedElementCellEditorLocator;
import org.eclipse.jwt.we.parts.core.directEdit.NamedElementDirectEditManager;
import org.eclipse.jwt.we.parts.core.policies.NamedElementDirectEditPolicy;

public class NamedElementEditPart
extends NodeModelElementEditPart {
    private DirectEditManager directEditManager;
    private boolean doDirectEdit = false;

    public Class getModelClass() {
        return NamedElement.class;
    }

    public void setDoDirectEdit(boolean doDirectEdit) {
        this.doDirectEdit = doDirectEdit;
        if (doDirectEdit) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new NamedElementDirectEditPolicy());
        } else {
            this.installEditPolicy("DirectEditPolicy", null);
        }
    }

    public void performRequest(Request request) {
        super.performRequest(request);
        if (this.doDirectEdit && request.getType() == "direct edit") {
            this.performDirectEdit();
        }
    }

    protected void performDirectEdit() {
        if (this.directEditManager == null) {
            this.directEditManager = new NamedElementDirectEditManager((GraphicalEditPart)this, new NamedElementCellEditorLocator((NamedElementFigure)this.getFigure()));
        }
        this.directEditManager.show();
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        int featureId = notification.getFeatureID(NamedElement.class);
        switch (notification.getEventType()) {
            case 1: 
            case 2: {
                switch (featureId) {
                    case 1: 
                    case 2: {
                        this.refreshVisuals();
                    }
                }
            }
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        IFigure figure = this.getFigure();
        NamedElement element = (NamedElement)this.getModel();
        if (figure instanceof NamedElementFigure) {
            Object icon;
            NamedElementFigure namedFigure = (NamedElementFigure)figure;
            namedFigure.setName(element.getName());
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.getModelAdapterFactory().adapt((Notifier)element, IItemLabelProvider.class);
            if (itemLabelProvider != null && (icon = itemLabelProvider.getImage((Object)element)) instanceof ImageDescriptor) {
                namedFigure.setIcon((ImageDescriptor)icon);
            }
        }
    }
}

