/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.ast;

import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.StaticContext;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeModel;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AttrElemTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathVisitor;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AttrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class AttributeTest
extends AttrElemTest {
    private AnyType anyType = null;

    public AttributeTest(QName name, boolean wild, QName type) {
        super(name, wild, type);
    }

    public AttributeTest(QName name, boolean wild) {
        super(name, wild);
    }

    public AttributeTest() {
    }

    @Override
    public Object accept(XPathVisitor v) {
        return v.visit(this);
    }

    @Override
    public AnyType createTestType(ResultSequence rs, StaticContext sc) {
        if (this.name() == null && !this.wild()) {
            return new AttrType();
        }
        Item at = rs.first();
        if (!(at instanceof NodeType)) {
            return new AttrType();
        }
        return this.createAttrType(at, sc);
    }

    private AnyType createAttrType(Item at, StaticContext sc) {
        this.anyType = new AttrType();
        NodeType nodeType = (NodeType)at;
        Node node = nodeType.node_value();
        if (node == null) {
            return this.anyType;
        }
        String nodeName = node.getLocalName();
        if (this.wild()) {
            if (this.type() != null) {
                this.anyType = this.createAttrForXSDType(node, sc);
            }
        } else if (nodeName.equals(this.name().local())) {
            this.anyType = this.type() != null ? this.createAttrForXSDType(node, sc) : new AttrType((Attr)node, sc.getTypeModel());
        }
        return this.anyType;
    }

    private AnyType createAttrForXSDType(Node node, StaticContext sc) {
        Attr attr = (Attr)node;
        TypeModel typeModel = sc.getTypeModel();
        TypeDefinition typedef = typeModel.getType(attr);
        if (typedef != null) {
            if (typedef.derivedFrom(this.type().namespace(), this.type().local(), this.getDerviationTypes())) {
                this.anyType = new AttrType(attr, sc.getTypeModel());
            }
        } else {
            this.anyType = new AttrType(attr, sc.getTypeModel());
        }
        return this.anyType;
    }

    @Override
    public boolean isWild() {
        return this.wild();
    }

    @Override
    public Class getXDMClassType() {
        return AttrType.class;
    }
}

