/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.callhierarchy;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.MethodCall;

class CallSearchResultCollector {
    private Map fCalledMembers = this.createCalledMethodsData();

    public Map getCallers() {
        return this.fCalledMembers;
    }

    protected void addMember(IMember member, IMember calledMember, int start, int end) {
        this.addMember(member, calledMember, start, end, -1);
    }

    protected void addMember(IMember member, IMember calledMember, int start, int end, int lineNumber) {
        if (member != null && calledMember != null && !this.isIgnored(calledMember)) {
            MethodCall methodCall = (MethodCall)this.fCalledMembers.get(calledMember.getHandleIdentifier());
            if (methodCall == null) {
                methodCall = new MethodCall(calledMember);
                this.fCalledMembers.put(calledMember.getHandleIdentifier(), methodCall);
            }
            methodCall.addCallLocation(new CallLocation(member, calledMember, start, end, lineNumber));
        }
    }

    protected Map createCalledMethodsData() {
        return new HashMap();
    }

    private boolean isIgnored(IMember enclosingElement) {
        IType type = this.getTypeOfElement(enclosingElement);
        String fullyQualifiedName = type != null ? type.getFullyQualifiedName() : enclosingElement.getJavaScriptUnit().getElementName();
        return CallHierarchy.getDefault().isIgnored(fullyQualifiedName);
    }

    private IType getTypeOfElement(IMember element) {
        if (element.getElementType() == 7) {
            return (IType)element;
        }
        return element.getDeclaringType();
    }
}

