/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.evaluator;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.UnitLocation;
import org.eclipse.ocl.examples.debug.vm.VMBreakpoint;
import org.eclipse.ocl.examples.debug.vm.VMBreakpointManager;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.LoopExp;

public class IterateBreakpointHelper {
    private final Set<VMBreakpoint> fBreakpoints;
    private final @NonNull VMBreakpointManager fBPM;

    public IterateBreakpointHelper(@NonNull VMBreakpointManager breakpointManager) {
        this.fBPM = breakpointManager;
        this.fBreakpoints = new HashSet<VMBreakpoint>();
    }

    public VMBreakpoint stepIterateElement(LoopExp element, UnitLocation currentLocation) {
        return null;
    }

    public boolean isIterateBreakpoint(VMBreakpoint breakpoint) {
        return this.fBreakpoints.contains(breakpoint);
    }

    public VMBreakpoint createIterateBreakpoint(URI unitURI, @NonNull Element breakpointedElement, int line) {
        VMBreakpoint breakpoint = null;
        try {
            breakpoint = this.fBPM.createVMPrivateBreakpoint(unitURI, breakpointedElement, line, false);
            this.fBreakpoints.add(breakpoint);
        }
        catch (CoreException e) {
            this.fBPM.getDebugCore().log(e.getStatus());
        }
        return breakpoint;
    }

    public void removeIterateBreakpoint(@NonNull VMBreakpoint breakpoint) {
        this.fBPM.removeBreakpoint(breakpoint);
        this.fBreakpoints.remove(breakpoint);
    }

    public void removeAllIterateBreakpoints() {
        for (VMBreakpoint brk : this.fBreakpoints) {
            this.fBPM.removeBreakpoint(brk);
        }
        this.fBreakpoints.clear();
    }
}

