/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.ui.actions;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ocl.examples.debug.vm.ValidBreakpointLocator;
import org.eclipse.ocl.examples.debug.vm.ui.DebugVMUIPlugin;
import org.eclipse.ocl.examples.debug.vm.utils.CompiledUnit;
import org.eclipse.ocl.examples.debug.vm.utils.LineNumberProvider;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.xtext.base.cs2as.CS2AS;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public abstract class BreakpointLocationVerifier {
    private final @NonNull ILineBreakpoint fBreakpoint;
    private final @NonNull ITextEditor fEditor;
    private final @NonNull String fInvalidLocationMessage;

    private static @NonNull LineNumberProvider getLineNumberProvider(final @NonNull IDocument doc) {
        return new LineNumberProvider(){

            public int getLineNumber(int offset) {
                try {
                    return doc.getLineOfOffset(offset) + 1;
                }
                catch (BadLocationException e) {
                    return -1;
                }
            }

            public int getLineEnd(int lineNumber) {
                try {
                    IRegion lineInfo = doc.getLineInformation(lineNumber);
                    return lineInfo.getOffset() + lineInfo.getLength();
                }
                catch (BadLocationException e) {
                    return -1;
                }
            }

            public int getLineCount() {
                return doc.getNumberOfLines();
            }
        };
    }

    protected BreakpointLocationVerifier(@NonNull ITextEditor editor, @NonNull ILineBreakpoint breakpoint, @NonNull String invalidLocationMessage) {
        this.fEditor = editor;
        this.fBreakpoint = breakpoint;
        this.fInvalidLocationMessage = invalidLocationMessage;
    }

    @NonNull IStatus run() {
        @NonNull IStatus status = this.checkBreakpointableElements();
        if (!status.isOK() && this.fBreakpoint != null) {
            try {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
            }
            catch (CoreException e) {
                DebugVMUIPlugin.log(e.getStatus());
            }
        }
        return status;
    }

    private @NonNull IStatus checkBreakpointableElements() {
        CompiledUnit compilationUnit;
        int lineNumber;
        try {
            lineNumber = this.fBreakpoint.getLineNumber();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        IDocumentProvider docProvider = this.fEditor.getDocumentProvider();
        if (docProvider == null) {
            return this.canceled();
        }
        IDocument doc = docProvider.getDocument((Object)this.fEditor.getEditorInput());
        if (doc == null) {
            return this.canceled();
        }
        Model root = (Model)((XtextDocument)doc).readOnly((IUnitOfWork)new IUnitOfWork<Model, XtextResource>(){

            public Model exec(@Nullable XtextResource state) throws Exception {
                EObject eObject;
                ASResource asResource;
                BaseCSResource csResource;
                CS2AS cs2as;
                if (state instanceof BaseCSResource && (cs2as = (csResource = (BaseCSResource)state).findCS2AS()) != null && (asResource = cs2as.getASResource()) != null && asResource.getContents().size() > 0 && (eObject = (EObject)asResource.getContents().get(0)) instanceof Model) {
                    return (Model)eObject;
                }
                return null;
            }
        });
        CompiledUnit compiledUnit = compilationUnit = root != null ? new CompiledUnit((Element)root) : null;
        if (compilationUnit == null) {
            return DebugVMUIPlugin.createErrorStatus("Failed to obtain AST");
        }
        List elements = this.getValidBreakpointLocator().getBreakpointableElementsForLine(compilationUnit, BreakpointLocationVerifier.getLineNumberProvider(doc), lineNumber);
        if (elements.isEmpty()) {
            this.report(NLS.bind((String)this.fInvalidLocationMessage, (Object)lineNumber));
            return this.canceled();
        }
        return Status.OK_STATUS;
    }

    protected abstract @NonNull ValidBreakpointLocator getValidBreakpointLocator();

    protected void report(final String message) {
        DebugVMUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                @Nullable IEditorStatusLine statusLine = (IEditorStatusLine)BreakpointLocationVerifier.this.fEditor.getAdapter(IEditorStatusLine.class);
                if (statusLine != null) {
                    statusLine.setMessage(true, message, null);
                }
                if (message != null && DebugVMUIPlugin.getActiveWorkbenchShell() != null) {
                    Display.getCurrent().beep();
                }
            }
        });
    }

    private @NonNull IStatus canceled() {
        return DebugVMUIPlugin.createStatus(8, this.fInvalidLocationMessage);
    }
}

