/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.efacet.ui.internal.widget;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.modisco.facet.efacet.core.FacetUtils;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.modisco.facet.efacet.ui.internal.Activator;
import org.eclipse.modisco.facet.efacet.ui.internal.Messages;
import org.eclipse.modisco.facet.efacet.ui.internal.utils.ImageProvider;
import org.eclipse.modisco.facet.efacet.ui.internal.widget.ETypedElementSelectionControl;
import org.eclipse.modisco.facet.efacet.ui.internal.widget.ETypedElementSelectionControlContentProvider;
import org.eclipse.modisco.facet.util.core.Logger;
import org.eclipse.modisco.facet.util.core.internal.exported.IFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class ETypedElementSelectionSortedControl
extends ETypedElementSelectionControl {
    private final Map<EPackage, Set<EObject>> groupByMap = new HashMap<EPackage, Set<EObject>>();
    private static final String NAME = Messages.ETypedElementSelectionSortedControl_groupByMetamodelView;
    public static final String GROUPED_TAB_ID = "group.by.metamodel.view.id";
    public static final String TOOLTIP = Messages.ETypedElementSelectionSortedControl_toolTip;

    public ETypedElementSelectionSortedControl(Composite parentComposite, int selectionMaxSize, boolean allowEmpty, Collection<? extends EObject> knownEPackage) {
        super(parentComposite, selectionMaxSize, allowEmpty, knownEPackage);
    }

    @Override
    public void setAvailableETypedElements(Collection<? extends ETypedElement> newAvailable) {
        this.available = newAvailable;
        this.prepareInput();
        this.setInput(this.groupByMap.keySet());
    }

    private void prepareInput() {
        if (this.available != null) {
            for (ETypedElement eTypedElement : this.available) {
                EObject container = ETypedElementSelectionSortedControl.getTopmostContainer((EObject)eTypedElement);
                if (container == null || !this.containsETypedElement(container)) continue;
                this.addContainer(container);
            }
        }
        for (EObject eObject : this.getKnownEPackage()) {
            if (!this.containsETypedElement(eObject)) continue;
            this.addContainer(eObject);
        }
    }

    private void addContainer(EObject container) {
        if (container instanceof FacetSet) {
            FacetSet facetSet = (FacetSet)container;
            Set packs = FacetUtils.getAllExtendedEPackage((FacetSet)facetSet);
            if (packs.isEmpty()) {
                Logger.logError((String)NLS.bind((String)"Package not found: {0}", (Object)container), (Plugin)Activator.getDefault());
            }
            for (EPackage current : packs) {
                this.getValues(current).add(container);
            }
        }
    }

    private Collection<EObject> getValues(EPackage pack) {
        if (!this.groupByMap.containsKey(pack)) {
            HashSet values = new HashSet();
            this.groupByMap.put(pack, values);
        }
        return this.groupByMap.get(pack);
    }

    @Override
    protected IContentProvider createContentProvider() {
        return new SortedContentProvider(new IFilter<EObject>(){

            public boolean filter(EObject eObject) {
                return ETypedElementSelectionSortedControl.this.filterChild(eObject);
            }
        });
    }

    @Override
    public String getTitle() {
        return NAME;
    }

    @Override
    public Image getImage() {
        return ImageProvider.getInstance().getTreeViewIcon();
    }

    @Override
    public String getToolTipText() {
        return TOOLTIP;
    }

    @Override
    public String getTabId() {
        return GROUPED_TAB_ID;
    }

    public Set<EObject> getChlidren(Object parentElement) {
        return this.groupByMap.get(parentElement);
    }

    private class SortedContentProvider
    extends ETypedElementSelectionControlContentProvider {
        public SortedContentProvider(IFilter<EObject> childrenFilter) {
            super(childrenFilter);
        }

        @Override
        public Object[] getChildren(Object parentElement) {
            Set<EObject> list = ETypedElementSelectionSortedControl.this.getChlidren(parentElement);
            Object[] children = list == null ? super.getChildren(parentElement) : list.toArray();
            return children;
        }

        @Override
        public Object getParent(Object element) {
            Set packs;
            Object parent = super.getParent(element);
            if (parent == null && element instanceof FacetSet && !(packs = FacetUtils.getAllExtendedEPackage((FacetSet)((FacetSet)element))).isEmpty()) {
                parent = packs.iterator().next();
            }
            return parent;
        }
    }
}

