/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.entity.data.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.wizards.entity.data.model.EntityRow;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class CreateEntityTemplateModel {
    protected IDataModel dataModel;
    private static final String DOT = ".";
    private static final String BRACKET = "[";
    private static final String PK_SUFFIX = "PK";
    private static final String QUALIFIED_SERIALIZABLE = "java.io.Serializable";
    private static final String PERSISTENCE_PACKAGE = "javax.persistence.*";
    private static final String JAKARTA_PACKAGE = "jakarta.persistence.*";
    private static final String ENTITY_ANNOTATION = "@Entity";
    private static final String MAPPED_AS_SUPERCLASS_TYPE = "@MappedSuperclass";
    private static final String INHERITANCE_TYPE = "@Inheritance";

    public CreateEntityTemplateModel(IDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public Collection<String> getImports(boolean isIdClass) {
        List interfaces;
        TreeSet<String> collection = new TreeSet<String>();
        String className = this.getClassName();
        String superclassName = this.getQualifiedSuperclassName();
        if (superclassName != null && superclassName.length() > 0 && !this.equalSimpleNames(className, superclassName)) {
            collection.add(superclassName);
        }
        if ((interfaces = this.getQualifiedInterfaces()) != null) {
            for (String iface : interfaces) {
                if (this.equalSimpleNames(this.getClassName(), iface)) continue;
                collection.add(iface);
            }
        }
        if (isIdClass) {
            collection.addAll(this.getIdClassImportList());
        } else {
            double jpaVersion = this.getJpaVersion();
            if (jpaVersion >= 3.0) {
                collection.add(JAKARTA_PACKAGE);
            } else {
                collection.add(PERSISTENCE_PACKAGE);
            }
            collection.addAll(this.getFieldImportList());
        }
        return collection;
    }

    public String getClassName() {
        return this.getProperty("NewJavaClassDataModel.CLASS_NAME").trim();
    }

    public String getJavaPackageName() {
        return this.getProperty("NewJavaClassDataModel.JAVA_PACKAGE").trim();
    }

    public String getQualifiedJavaClassName() {
        if (!this.getJavaPackageName().equals("")) {
            return String.valueOf(this.getJavaPackageName()) + DOT + this.getClassName();
        }
        return this.getClassName();
    }

    public String getSuperclassName() {
        String qualified = this.getQualifiedSuperclassName();
        if (this.equalSimpleNames(this.getClassName(), qualified)) {
            return qualified;
        }
        return Signature.getSimpleName((String)qualified);
    }

    public String getQualifiedSuperclassName() {
        return this.getProperty("NewJavaClassDataModel.SUPERCLASS").trim();
    }

    public List<String> getInterfaces() {
        List qualifiedInterfaces = this.getQualifiedInterfaces();
        ArrayList<String> interfaces = new ArrayList<String>(qualifiedInterfaces.size());
        for (String qualified : qualifiedInterfaces) {
            if (this.equalSimpleNames(this.getClassName(), qualified)) {
                interfaces.add(qualified);
                continue;
            }
            interfaces.add(Signature.getSimpleName((String)qualified));
        }
        return interfaces;
    }

    public List getQualifiedInterfaces() {
        ArrayList<String> interfaces = (ArrayList<String>)this.dataModel.getProperty("NewJavaClassDataModel.INTERFACES");
        if (interfaces == null) {
            interfaces = new ArrayList<String>();
        }
        interfaces.add(QUALIFIED_SERIALIZABLE);
        return interfaces;
    }

    protected String getProperty(String propertyName) {
        return this.dataModel.getStringProperty(propertyName);
    }

    protected boolean equalSimpleNames(String name1, String name2) {
        String simpleName1 = Signature.getSimpleName((String)name1);
        String simpleName2 = Signature.getSimpleName((String)name2);
        return simpleName1.equals(simpleName2);
    }

    public String getArtifactType() {
        if (this.dataModel.getBooleanProperty("IEntityDataModelProperties.MAPPED_AS_SUPERCLASS")) {
            return MAPPED_AS_SUPERCLASS_TYPE;
        }
        return ENTITY_ANNOTATION;
    }

    public boolean isInheritanceSet() {
        return this.dataModel.getBooleanProperty("IEntityDataModelProperties.INHERITANCE");
    }

    public String getInheritanceStrategyName() {
        return this.getProperty("IEntityDataModelProperties.INHERITANCE_STRATEGY");
    }

    public String getInheritanceStrategy() {
        String result = "";
        if (this.isInheritanceSet()) {
            result = INHERITANCE_TYPE;
            if (!this.getProperty("IEntityDataModelProperties.INHERITANCE_STRATEGY").equals("")) {
                result = String.valueOf(result) + "(strategy=InheritanceType." + this.getProperty("IEntityDataModelProperties.INHERITANCE_STRATEGY") + ")";
            }
        }
        return result;
    }

    public boolean isNonEntitySuperclass() {
        return !this.dataModel.getBooleanProperty("IEntityDataModelProperties.ENTITY");
    }

    public boolean isArtifactsAnnotated() {
        return !this.dataModel.getBooleanProperty("IEntityDataModelProperties.XML_SUPPORT");
    }

    public boolean isMappingXMLDefault() {
        if (this.getMappingXMLName().equals("")) {
            return true;
        }
        return this.getMappingXMLName().equals("META-INF/orm.xml");
    }

    public String getMappingXMLName() {
        return this.dataModel.getStringProperty("IEntityDataModelProperties.XML_NAME").trim();
    }

    public IFile getMappingXmlFile() {
        IPackageFragmentRoot[] sourceFragments;
        IFile ormFile = null;
        IProject project = this.getProject();
        IPackageFragmentRoot[] iPackageFragmentRootArray = sourceFragments = J2EEProjectUtilities.getSourceContainers((IProject)project);
        int n = sourceFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
            ormFile = project.getFile(String.valueOf(packageFragmentRoot.getResource().getName()) + File.separator + this.getMappingXMLName());
            if (ormFile.exists()) break;
            ++n2;
        }
        return ormFile;
    }

    public String getEntityName() {
        return this.getProperty("IEntityDataModelProperties.ENTITY_NAME").trim();
    }

    public boolean isEntityNameSet() {
        boolean result = false;
        if (!StringTools.isBlank((String)this.getEntityName()) && !this.getClassName().equals(this.getEntityName())) {
            result = true;
        }
        return result;
    }

    public boolean isTableNameSet() {
        return !this.dataModel.getBooleanProperty("IEntityDataModelProperties.TABLE_NAME_DEFAULT");
    }

    public String getTableName() {
        return this.getProperty("IEntityDataModelProperties.TABLE_NAME").trim();
    }

    public List<EntityRow> getEntityFields() {
        ArrayList fields = (ArrayList)this.dataModel.getProperty("IEntityDataModelProperties.ENTITY_FIELDS");
        if (fields == null) {
            return new ArrayList<EntityRow>();
        }
        return fields;
    }

    public List<String> getFieldImportList() {
        ArrayList<String> imports = new ArrayList<String>();
        List<EntityRow> entities = this.getEntityFields();
        for (EntityRow entityRow : entities) {
            if (imports.contains(entityRow.getFqnTypeName()) || entityRow.getType().equals(entityRow.getFqnTypeName())) continue;
            String fqnTypeName = entityRow.getFqnTypeName();
            if (fqnTypeName.indexOf(BRACKET) != -1) {
                fqnTypeName = fqnTypeName.substring(0, fqnTypeName.indexOf(BRACKET));
            }
            imports.add(fqnTypeName);
        }
        return imports;
    }

    public List<String> getIdClassImportList() {
        ArrayList<String> imports = new ArrayList<String>();
        List<EntityRow> entities = this.getEntityFields();
        List<String> pkFields = this.getPKFields();
        for (EntityRow entityRow : entities) {
            String name = entityRow.getName();
            if (!pkFields.contains(name) || imports.contains(entityRow.getFqnTypeName()) || entityRow.getType().equals(entityRow.getFqnTypeName())) continue;
            imports.add(entityRow.getFqnTypeName());
        }
        return imports;
    }

    public boolean isFieldAccess() {
        return this.dataModel.getBooleanProperty("IEntityDataModelProperties.FIELD_ACCESS_TYPE");
    }

    public boolean isCompositePK() {
        return this.getPKFields().size() > 1;
    }

    public List<String> getPKFields() {
        return (ArrayList)this.dataModel.getProperty("IEntityDataModelProperties.PK_FIELDS");
    }

    public String getIdClassName() {
        return String.valueOf(this.getClassName()) + PK_SUFFIX;
    }

    public String getOrmIdClassName() {
        return String.valueOf(this.getQualifiedJavaClassName()) + PK_SUFFIX;
    }

    public IProject getProject() {
        String projectName = this.dataModel.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        return ProjectUtilities.getProject((String)projectName);
    }

    public JpaProject getJpaProject() {
        IProject project = this.getProject();
        if (project != null) {
            return (JpaProject)project.getAdapter(JpaProject.class);
        }
        return null;
    }

    private double getJpaVersion() {
        JpaProject jpaProject = this.getJpaProject();
        JpaPlatform jpaPlatform = jpaProject.getJpaPlatform();
        if (jpaPlatform == null) {
            JptJpaUiPlugin.instance().logError("JpaPlatform is null for project: " + jpaProject.getProject().getName());
            return -1.0;
        }
        JpaPlatform.Version version = jpaPlatform.getJpaVersion();
        if (version != null) {
            String versionString = version.getJpaVersion();
            try {
                return Double.parseDouble(versionString);
            }
            catch (NumberFormatException numberFormatException) {
                JptJpaUiPlugin.instance().logError("Invalid JPA version format: " + versionString);
            }
        }
        return -1.0;
    }
}

