/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.core.liqp.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.embedcdt.core.liqp.filters.Filter;

class Sort
extends Filter {
    Sort() {
    }

    @Override
    public Object apply(Object value, Object ... params) {
        if (value == null) {
            return "";
        }
        if (!super.isArray(value)) {
            throw new RuntimeException("cannot sort: " + value);
        }
        Object[] array = super.asArray(value);
        String property = params.length == 0 ? null : super.asString(params[0]);
        List<Comparable> list = this.asComparableList(array, property);
        Collections.sort(list);
        return property == null ? list.toArray(new Comparable[list.size()]) : list.toArray(new SortableMap[list.size()]);
    }

    private List<Comparable> asComparableList(Object[] array, String property) {
        ArrayList<Comparable> list = new ArrayList<Comparable>();
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof Map && property != null) {
                list.add(new SortableMap((Map)obj, property));
            } else {
                list.add((Comparable)obj);
            }
            ++n2;
        }
        return list;
    }

    static class SortableMap
    extends HashMap<String, Comparable>
    implements Comparable<SortableMap> {
        final String property;

        SortableMap(Map<String, Comparable> map, String property) {
            super.putAll(map);
            this.property = property;
        }

        @Override
        public int compareTo(SortableMap that) {
            Comparable thisValue = (Comparable)this.get(this.property);
            Comparable thatValue = (Comparable)that.get(this.property);
            if (thisValue == null || thatValue == null) {
                throw new RuntimeException("Liquid error: comparison of Hash with Hash failed");
            }
            return thisValue.compareTo(thatValue);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : super.entrySet()) {
                builder.append(entry.getKey()).append(entry.getValue());
            }
            return builder.toString();
        }
    }
}

