/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.npm;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wildwebdeveloper.debug.AbstractDebugAdapterLaunchShortcut;
import org.eclipse.wildwebdeveloper.debug.Messages;
import org.eclipse.wildwebdeveloper.debug.SelectionUtils;
import org.eclipse.wildwebdeveloper.debug.npm.NpmLaunchShortcut;

public class NpmLaunchTab
extends AbstractLaunchConfigurationTab {
    private Text programPathText;
    protected Composite resComposite;
    protected AbstractDebugAdapterLaunchShortcut shortcut = new NpmLaunchShortcut();
    private Combo argumentsCombo;
    private File packageJSONFile;
    private File defaultSelectedFile;

    public void createControl(Composite parent) {
        this.resComposite = new Composite(parent, 0);
        this.resComposite.setLayout((Layout)new GridLayout(2, false));
        new Label(this.resComposite, 0).setText(org.eclipse.wildwebdeveloper.debug.npm.Messages.NPMLaunchTab_argumentLabel);
        this.argumentsCombo = new Combo(this.resComposite, 2564);
        this.argumentsCombo.setLayoutData((Object)new GridData(4, -1, true, false));
        NpmLaunchTab.addComboItems(this.argumentsCombo, "install", "update", "ci", "pack", "run", "run-script", "start", "restart", "test");
        this.argumentsCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        }));
        this.argumentsCombo.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        new Label(this.resComposite, 0).setText(org.eclipse.wildwebdeveloper.debug.npm.Messages.NPMLaunchTab_programPathLabel);
        Composite filePathComposite = new Composite(this.resComposite, 0);
        filePathComposite.setLayout((Layout)new GridLayout(2, false));
        filePathComposite.setLayoutData((Object)new GridData(4, -1, true, false));
        this.programPathText = new Text(filePathComposite, 2048);
        this.programPathText.setLayoutData((Object)new GridData(4, -1, true, false));
        ControlDecoration decoration = new ControlDecoration((Control)this.programPathText, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        decoration.setImage(fieldDecoration.getImage());
        this.programPathText.addModifyListener(event -> {
            this.setDirty(true);
            try {
                File file = new File(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.programPathText.getText()));
                if (!file.isFile()) {
                    String errorMessage = Messages.RunProgramTab_error_unknownFile;
                    this.setErrorMessage(errorMessage);
                    decoration.setDescriptionText(errorMessage);
                    decoration.show();
                } else if (!this.shortcut.canLaunch(file)) {
                    String errorMessage = org.eclipse.wildwebdeveloper.debug.npm.Messages.NPMLaunchTab_notPackageJSONFile;
                    this.setErrorMessage(errorMessage);
                    decoration.setDescriptionText(errorMessage);
                    decoration.show();
                } else if (!file.canRead()) {
                    String errorMessage = Messages.RunProgramTab_error_nonReadableFile;
                    this.setErrorMessage(errorMessage);
                    decoration.setDescriptionText(errorMessage);
                    decoration.show();
                } else {
                    this.setErrorMessage(null);
                    decoration.hide();
                }
            }
            catch (CoreException ex) {
                this.setErrorMessage(ex.getMessage());
                decoration.setDescriptionText(ex.getMessage());
                decoration.show();
            }
            this.updateLaunchConfigurationDialog();
        });
        Button filePath = new Button(filePathComposite, 8);
        filePath.setLayoutData((Object)new GridData(131072, -1, false, false));
        filePath.setText(Messages.AbstractRunHTMLDebugTab_browse);
        filePath.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog filePathDialog = new FileDialog(this.resComposite.getShell());
            filePathDialog.setFilterPath(SelectionUtils.getSelectedProject() == null ? null : SelectionUtils.getSelectedProject().getAbsolutePath());
            filePathDialog.setText(org.eclipse.wildwebdeveloper.debug.npm.Messages.NPMLaunchTab_selectPackageJSON);
            String path = filePathDialog.open();
            if (path != null) {
                this.packageJSONFile = new File(path);
                this.programPathText.setText(this.packageJSONFile.getAbsolutePath());
                this.setDirty(true);
                this.updateLaunchConfigurationDialog();
            }
        }));
        this.setControl((Control)this.resComposite);
    }

    public static void addComboItems(Combo combo, String ... commands) {
        String[] stringArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String command = stringArray[n2];
            combo.add(command);
            ++n2;
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.defaultSelectedFile = SelectionUtils.getSelectedFile(this.shortcut::canLaunch);
            String defaultSelectedFilePath = SelectionUtils.pathOrEmpty(this.defaultSelectedFile);
            this.programPathText.setText(configuration.getAttribute("program", defaultSelectedFilePath));
            this.argumentsCombo.setText(configuration.getAttribute("runtimeArgs", "install"));
        }
        catch (CoreException e) {
            ILog.get().log(e.getStatus());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String workingDirectory = SelectionUtils.pathOrEmpty(SelectionUtils.getSelectedProject());
        if (this.packageJSONFile != null) {
            workingDirectory = SelectionUtils.pathOrEmpty(this.packageJSONFile.getParentFile());
        } else if (this.defaultSelectedFile != null) {
            workingDirectory = SelectionUtils.pathOrEmpty(this.defaultSelectedFile.getParentFile());
        }
        String programPath = this.programPathText.getText();
        configuration.setAttribute("program", programPath);
        configuration.setAttribute("runtimeArgs", this.argumentsCombo.getText());
        configuration.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", workingDirectory);
        configuration.setMappedResources((IResource[])ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(new File(programPath).toURI()));
    }

    public String getName() {
        return Messages.RunProgramTab_title;
    }
}

