/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.gef.graphical;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.draw2d.EventManager;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.gef.core.EditDomain;

public class EditEventManager
extends EventManager {
    private final EditDomain m_domain;
    private final IEditPartViewer m_viewer;
    private boolean m_eventCapture;
    private Cursor m_overrideCursor;
    private MouseEvent m_currentMouseEvent;

    public EditEventManager(FigureCanvas canvas, EditDomain domain, IEditPartViewer viewer) {
        super(canvas);
        this.m_domain = domain;
        this.m_viewer = viewer;
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (this.m_overrideCursor == null) {
            super.setCursor(cursor);
        } else {
            super.setCursor(this.m_overrideCursor);
        }
    }

    public void setOverrideCursor(Cursor cursor) {
        if (this.m_overrideCursor != cursor) {
            this.m_overrideCursor = cursor;
            if (this.m_overrideCursor == null) {
                if (this.m_eventCapture) {
                    super.setCursor(null);
                } else {
                    this.updateFigureUnderCursor(this.m_currentMouseEvent);
                    this.updateCursor();
                }
            } else {
                this.setCursor(this.m_overrideCursor);
            }
        }
    }

    @Override
    public void dispatchKeyPressed(KeyEvent event) {
        this.m_domain.keyDown(event, this.m_viewer);
    }

    @Override
    public void dispatchKeyReleased(KeyEvent event) {
        this.m_domain.keyUp(event, this.m_viewer);
    }

    @Override
    public void dispatchMouseDoubleClicked(MouseEvent event) {
        this.delayEvent(() -> {
            this.m_currentMouseEvent = event;
            if (!this.m_eventCapture) {
                super.dispatchMouseDoubleClicked(event);
                if (this.isEventConsumed()) {
                    return;
                }
            }
            this.m_domain.mouseDoubleClick(event, this.m_viewer);
        }, event);
    }

    @Override
    public void dispatchMousePressed(MouseEvent event) {
        this.delayEvent(() -> {
            this.m_viewer.getControl().forceFocus();
            this.m_currentMouseEvent = event;
            if (!this.m_eventCapture) {
                super.dispatchMousePressed(event);
                if (this.isEventConsumed()) {
                    return;
                }
            }
            this.m_eventCapture = true;
            this.m_domain.mouseDown(event, this.m_viewer);
        }, event);
    }

    @Override
    public void dispatchMouseReleased(MouseEvent event) {
        this.delayEvent(() -> {
            this.m_currentMouseEvent = event;
            if (!this.m_eventCapture) {
                super.dispatchMouseReleased(event);
                if (this.isEventConsumed()) {
                    return;
                }
            }
            boolean eventCapture = this.m_eventCapture;
            this.m_eventCapture = false;
            this.m_domain.mouseUp(event, this.m_viewer);
            if (eventCapture) {
                this.updateFigureUnderCursor(event);
            }
        }, event);
    }

    @Override
    public void dispatchMouseMoved(MouseEvent event) {
        this.delayEvent(() -> {
            this.m_currentMouseEvent = event;
            if (!this.m_eventCapture) {
                super.dispatchMouseMoved(event);
                if (this.isEventConsumed()) {
                    return;
                }
            }
            if ((mouseEvent.stateMask & SWT.BUTTON_MASK) != 0) {
                this.m_domain.mouseDrag(event, this.m_viewer);
            } else {
                this.m_domain.mouseMove(event, this.m_viewer);
            }
        }, event);
    }

    @Override
    public void dispatchMouseEntered(MouseEvent event) {
        this.delayEvent(() -> {
            this.m_currentMouseEvent = event;
            this.m_domain.viewerEntered(event, this.m_viewer);
            this.updateFigureUnderCursor(event);
        }, event);
    }

    @Override
    public void dispatchMouseExited(MouseEvent event) {
        this.delayEvent(() -> {
            this.m_eventCapture = false;
            this.m_currentMouseEvent = event;
            this.m_domain.viewerExited(event, this.m_viewer);
            this.updateFigureUnderCursor(event);
        }, event);
    }

    @Override
    public void dispatchMouseHover(MouseEvent event) {
    }
}

