/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.remote.launcher;

import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.terminal.connector.ISettingsStore;
import org.eclipse.terminal.connector.ITerminalConnector;
import org.eclipse.terminal.connector.InMemorySettingsStore;
import org.eclipse.terminal.connector.TerminalConnectorExtension;
import org.eclipse.terminal.view.core.ITerminalService;
import org.eclipse.terminal.view.ui.IMementoHandler;
import org.eclipse.terminal.view.ui.launcher.AbstractLauncherDelegate;
import org.eclipse.terminal.view.ui.launcher.IConfigurationPanel;
import org.eclipse.terminal.view.ui.launcher.IConfigurationPanelContainer;
import org.eclipse.tm.terminal.connector.remote.controls.RemoteWizardConfigurationPanel;
import org.eclipse.tm.terminal.connector.remote.internal.Activator;
import org.eclipse.tm.terminal.connector.remote.internal.RemoteSettings;
import org.eclipse.tm.terminal.connector.remote.launcher.RemoteMementoHandler;
import org.eclipse.tm.terminal.connector.remote.nls.Messages;

public class RemoteLauncherDelegate
extends AbstractLauncherDelegate {
    private final IMementoHandler mementoHandler = new RemoteMementoHandler();

    public boolean needsUserConfiguration() {
        return true;
    }

    public IConfigurationPanel getPanel(IConfigurationPanelContainer container) {
        return new RemoteWizardConfigurationPanel(container);
    }

    public CompletableFuture<?> execute(Map<String, Object> properties) {
        Assert.isNotNull(properties);
        String terminalTitle = this.getTerminalTitle(properties);
        if (terminalTitle != null) {
            properties.put("title", terminalTitle);
        }
        if (!properties.containsKey("terminal.forceNew")) {
            properties.put("terminal.forceNew", Boolean.TRUE);
        }
        ITerminalService terminal = this.getTerminalService();
        return terminal.openConsole(properties);
    }

    private String getTerminalTitle(Map<String, Object> properties) {
        String title = this.getDefaultTerminalTitle(properties);
        if (title != null) {
            return title;
        }
        String connection = (String)properties.get("ConnectionName");
        if (connection != null) {
            DateFormat format = DateFormat.getDateTimeInstance(3, 3);
            String date = format.format(new Date(System.currentTimeMillis()));
            return NLS.bind((String)Messages.RemoteLauncherDelegate_terminalTitle, (Object[])new String[]{connection, date});
        }
        return Messages.RemoteLauncherDelegate_terminalTitle_default;
    }

    public Object getAdapter(Class adapter) {
        if (IMementoHandler.class.equals((Object)adapter)) {
            return this.mementoHandler;
        }
        return super.getAdapter(adapter);
    }

    public ITerminalConnector createTerminalConnector(Map<String, Object> properties) throws CoreException {
        IRemoteConnection remoteConnection;
        IRemoteServicesManager svcMgr;
        IRemoteConnectionType connType;
        Assert.isNotNull(properties);
        String connectorId = (String)properties.get("tm.terminal.connector.id");
        if (connectorId == null) {
            connectorId = "org.eclipse.tm.terminal.connector.remote.RemoteConnector";
        }
        String connTypeId = (String)properties.get("ConnectionTypeId");
        String connName = (String)properties.get("ConnectionName");
        InMemorySettingsStore store = new InMemorySettingsStore();
        RemoteSettings remoteSettings = new RemoteSettings();
        remoteSettings.setConnectionTypeId(connTypeId);
        remoteSettings.setConnectionName(connName);
        remoteSettings.save((ISettingsStore)store);
        ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)connectorId);
        connector.setDefaultSettings();
        connector.load((ISettingsStore)store);
        if (!properties.containsKey("encoding") && (connType = (svcMgr = Activator.getService(IRemoteServicesManager.class)).getConnectionType(connTypeId)) != null && (remoteConnection = connType.getConnection(connName)) != null && remoteConnection.isOpen()) {
            properties.put("encoding", remoteConnection.getProperty("locale.charmap"));
        }
        properties.put("process.working_dir", "/tmp");
        return connector;
    }
}

