/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.execute;

import java.util.Arrays;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.acquire.LicenseAcquisitionService;
import org.eclipse.passage.lic.api.acquire.LicenseAcquisitionServicesRegistry;
import org.eclipse.passage.lic.api.conditions.ConditionMiningTarget;
import org.eclipse.passage.lic.api.conditions.mining.MinedConditions;
import org.eclipse.passage.lic.api.conditions.mining.MinedConditionsRegistry;
import org.eclipse.passage.lic.api.conditions.mining.MiningEquipment;
import org.eclipse.passage.lic.api.io.HashesRegistry;
import org.eclipse.passage.lic.api.registry.Registry;
import org.eclipse.passage.lic.base.acquire.UserHomeLicenseAcquisitionService;
import org.eclipse.passage.lic.base.conditions.mining.UserHomeResidentConditions;
import org.eclipse.passage.lic.base.registry.ReadOnlyRegistry;
import org.eclipse.passage.lic.equinox.acquire.ConfigurationLicenseAcquisitionService;
import org.eclipse.passage.lic.equinox.acquire.InstallationLicenseAcquisitionService;
import org.eclipse.passage.lic.execute.ConfigurationResidentConditions;
import org.eclipse.passage.lic.execute.InstallationResidentConditions;
import org.eclipse.passage.lic.execute.LicensingDirection;

public final class PersonalLicensing
implements LicensingDirection {
    private final Registry<ConditionMiningTarget, MinedConditions> conditions;
    private final Registry<ConditionMiningTarget, LicenseAcquisitionService> acquirers;

    public PersonalLicensing(Supplier<MiningEquipment> equipment) {
        this.conditions = new ReadOnlyRegistry(Arrays.asList(new MinedConditions[]{new UserHomeResidentConditions(equipment.get()), new InstallationResidentConditions(equipment.get()), new ConfigurationResidentConditions(equipment.get())}));
        this.acquirers = new ReadOnlyRegistry(Arrays.asList(new UserHomeLicenseAcquisitionService(), new InstallationLicenseAcquisitionService(), new ConfigurationLicenseAcquisitionService()));
    }

    @Override
    public final MinedConditionsRegistry conditionMiners() {
        return () -> this.conditions;
    }

    @Override
    public final LicenseAcquisitionServicesRegistry acquirers() {
        return () -> this.acquirers;
    }

    @Override
    public final HashesRegistry hashes() {
        return () -> new ReadOnlyRegistry();
    }
}

