/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.common.ui.internal.controls;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.modisco.facet.common.ui.internal.controls.wrappers.Column;
import org.eclipse.modisco.facet.common.ui.internal.controls.wrappers.SortableTable;
import org.eclipse.modisco.facet.common.ui.internal.controls.wrappers.SortableTree;
import org.eclipse.modisco.facet.common.ui.internal.controls.wrappers.SortableWidget;
import org.eclipse.modisco.facet.common.ui.internal.controls.wrappers.SortableWidgetFactory;
import org.eclipse.modisco.facet.common.ui.internal.controls.wrappers.TableColumn;
import org.eclipse.modisco.facet.common.ui.internal.controls.wrappers.TreeColumn;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.ui.IMemento;

public class PersistableColumn {
    private static final Map<String, Integer> COLUMN_WIDTHS = new HashMap<String, Integer>();
    private String fUniqueID;
    private final ViewerColumn fViewerColumn;

    private Column getColumn() {
        if (this.fViewerColumn instanceof TreeViewerColumn) {
            TreeViewerColumn treeViewerColumn = (TreeViewerColumn)this.fViewerColumn;
            return new TreeColumn(treeViewerColumn.getColumn());
        }
        if (this.fViewerColumn instanceof TableViewerColumn) {
            TableViewerColumn tableViewerColumn = (TableViewerColumn)this.fViewerColumn;
            return new TableColumn(tableViewerColumn.getColumn());
        }
        throw new IllegalStateException("neither a table nor tree column");
    }

    protected void init(String columnText, final String uniqueID, int defaultWidth, ColumnLabelProvider columnLabelProvider) {
        this.fUniqueID = uniqueID;
        final Column column = this.getColumn();
        column.setText(columnText);
        Integer width = PersistableColumn.getColumnWidths().get(uniqueID);
        if (width != null) {
            column.setWidth(width);
        } else {
            column.setWidth(defaultWidth);
        }
        column.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                PersistableColumn.getColumnWidths().put(uniqueID, new Integer(column.getWidth()));
            }
        });
        this.fViewerColumn.setLabelProvider((CellLabelProvider)columnLabelProvider);
    }

    public PersistableColumn(String columnText, String uniqueID, int defaultWidth, ColumnLabelProvider columnLabelProvider, TreeViewer treeViewer) {
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(treeViewer, 0);
        this.fViewerColumn = treeViewerColumn;
        this.init(columnText, uniqueID, defaultWidth, columnLabelProvider);
        PersistableColumn.addSorter(new TreeColumn(treeViewerColumn.getColumn()), PersistableColumn.getViewerSorter(columnLabelProvider), new SortableTree(treeViewer));
    }

    public PersistableColumn(String columnText, String uniqueID, int defaultWidth, ColumnLabelProvider columnLabelProvider, TableViewer tableViewer) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
        this.fViewerColumn = tableViewerColumn;
        this.init(columnText, uniqueID, defaultWidth, columnLabelProvider);
        PersistableColumn.addSorter(new TableColumn(tableViewerColumn.getColumn()), PersistableColumn.getViewerSorter(columnLabelProvider), new SortableTable(tableViewer));
    }

    private static ViewerSorter getViewerSorter(final ColumnLabelProvider columnLabelProvider) {
        return new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String text1 = columnLabelProvider.getText(e1);
                String text2 = columnLabelProvider.getText(e2);
                if (text1 == null) {
                    return -1;
                }
                int compare = text1.compareTo(text2);
                SortableWidget sortableWidget = SortableWidgetFactory.createSortableWidget(viewer);
                if (sortableWidget.getSortDirection() == 1024) {
                    compare *= -1;
                }
                return compare;
            }
        };
    }

    private static void addSorter(final Column column, final ViewerSorter viewerSorter, final SortableWidget sortableWidget) {
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                sortableWidget.setSorter(viewerSorter);
                sortableWidget.setSortColumn(column);
                if (sortableWidget.getSortDirection() == 128) {
                    sortableWidget.setSortDirection(1024);
                } else if (sortableWidget.getSortDirection() == 1024) {
                    sortableWidget.setSortDirection(128);
                } else {
                    sortableWidget.setSortDirection(128);
                }
                sortableWidget.refresh();
            }
        });
    }

    public void saveState(IMemento memento) {
        Integer width = PersistableColumn.getColumnWidths().get(this.fUniqueID);
        if (width != null) {
            memento.putInteger(this.fUniqueID, width.intValue());
        }
    }

    public static void loadState(IMemento memento, String columnID) {
        Integer width = memento.getInteger(columnID);
        if (width != null) {
            PersistableColumn.getColumnWidths().put(columnID, width);
        }
    }

    public void setWidth(int width) {
        this.getColumn().setWidth(width);
    }

    protected static Map<String, Integer> getColumnWidths() {
        return COLUMN_WIDTHS;
    }
}

