/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jpt.common.core.internal.utility.jdt.AbstractExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;

public final class StringExpressionConverter
extends AbstractExpressionConverter<String> {
    private static final ExpressionConverter<String> INSTANCE = new StringExpressionConverter();

    public static ExpressionConverter<String> instance() {
        return INSTANCE;
    }

    private StringExpressionConverter() {
    }

    protected StringLiteral convertObject(String string, AST ast) {
        StringLiteral stringLiteral = ast.newStringLiteral();
        stringLiteral.setLiteralValue(string);
        return stringLiteral;
    }

    @Override
    protected String convertExpression(Expression expression) {
        Object value = expression.resolveConstantExpressionValue();
        return value instanceof String ? (String)value : null;
    }
}

