/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotationStringArrayExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NameStringExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.StringTools;

public class EnumArrayDeclarationAnnotationElementAdapter
implements DeclarationAnnotationElementAdapter<String[]> {
    private final ConversionDeclarationAnnotationElementAdapter<String[]> adapter;

    public EnumArrayDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter) {
        this(annotationAdapter, "value");
    }

    public EnumArrayDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        this(annotationAdapter, elementName, true);
    }

    public EnumArrayDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, boolean removeArrayInitializerWhenEmpty) {
        this(new ConversionDeclarationAnnotationElementAdapter<String[]>(annotationAdapter, elementName, EnumArrayDeclarationAnnotationElementAdapter.buildExpressionConverter(removeArrayInitializerWhenEmpty)));
    }

    private static ExpressionConverter<String[]> buildExpressionConverter(boolean removeArrayInitializerWhenEmpty) {
        return new AnnotationStringArrayExpressionConverter(NameStringExpressionConverter.instance(), removeArrayInitializerWhenEmpty);
    }

    protected EnumArrayDeclarationAnnotationElementAdapter(ConversionDeclarationAnnotationElementAdapter<String[]> adapter) {
        this.adapter = adapter;
    }

    @Override
    public String[] getValue(ModifiedDeclaration declaration) {
        return this.resolve(this.getExpression(declaration));
    }

    @Override
    public String[] getValue(Annotation astAnnotation) {
        return this.resolve(this.getExpression(astAnnotation));
    }

    @Override
    public void setValue(String[] value, ModifiedDeclaration declaration) {
        this.adapter.setValue(this.convertToSourceCodeNames(value, declaration), declaration);
    }

    @Override
    public Expression getExpression(ModifiedDeclaration declaration) {
        return this.adapter.getExpression(declaration);
    }

    @Override
    public Expression getExpression(Annotation astAnnotation) {
        return this.adapter.getExpression(astAnnotation);
    }

    @Override
    public ASTNode getAstNode(ModifiedDeclaration declaration) {
        return this.adapter.getAstNode(declaration);
    }

    protected String[] resolve(Expression expression) {
        if (expression == null) {
            return StringTools.EMPTY_STRING_ARRAY;
        }
        if (expression.getNodeType() == 4) {
            return this.resolveArray((ArrayInitializer)expression);
        }
        return this.resolveSingleElement(expression);
    }

    protected String[] resolveArray(ArrayInitializer ai) {
        List<Expression> expressions = this.expressions(ai);
        int len = expressions.size();
        String[] enums = new String[len];
        int i = len;
        while (i-- > 0) {
            enums[i] = this.resolveEnum(expressions.get(i));
        }
        return enums;
    }

    protected String[] resolveSingleElement(Expression enumExpression) {
        return new String[]{this.resolveEnum(enumExpression)};
    }

    protected String resolveEnum(Expression expression) {
        return ASTTools.resolveEnum(expression);
    }

    private List<Expression> expressions(ArrayInitializer arrayInitializer) {
        return arrayInitializer.expressions();
    }

    protected String[] convertToSourceCodeNames(String[] enums, ModifiedDeclaration declaration) {
        if (enums == null) {
            return null;
        }
        int len = enums.length;
        String[] sourceCodeNames = new String[len];
        int i = 0;
        while (i < len) {
            sourceCodeNames[i] = this.convertToSourceCodeName(enums[i], declaration);
            ++i;
        }
        return sourceCodeNames;
    }

    protected String convertToSourceCodeName(String enum_, ModifiedDeclaration declaration) {
        return EnumDeclarationAnnotationElementAdapter.convertToSourceCodeName(enum_, declaration);
    }
}

