/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.client.IAssemblyDescriptor;
import org.eclipse.emf.cdo.lm.client.IAssemblyManager;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.modules.DependencyDefinition;
import org.eclipse.emf.cdo.lm.modules.provider.DependencyDefinitionItemProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.net4j.util.factory.ProductCreationException;

public class LMTargetNameProvider
implements DependencyDefinitionItemProvider.TargetNameProvider {
    public Collection<String> getTargetNames(DependencyDefinition dependency) {
        IAssemblyDescriptor assemblyDescriptor = IAssemblyManager.INSTANCE.getDescriptor((EObject)dependency);
        if (assemblyDescriptor != null) {
            ISystemDescriptor systemDescriptor = assemblyDescriptor.getSystemDescriptor();
            String owningName = assemblyDescriptor.getBaseline().getModule().getName();
            ArrayList<String> result = new ArrayList<String>();
            for (Module module : systemDescriptor.getSystem().getModules()) {
                String name = module.getName();
                if (Objects.equals(name, owningName)) continue;
                result.add(name);
            }
            result.sort(null);
            return result;
        }
        return null;
    }

    public static final class Factory
    extends DependencyDefinitionItemProvider.TargetNameProvider.Factory {
        public static final String TYPE = "lm";

        public Factory() {
            super(TYPE);
        }

        public DependencyDefinitionItemProvider.TargetNameProvider create(String description) throws ProductCreationException {
            return new LMTargetNameProvider();
        }
    }
}

