/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.geometry.Rectangle;

public interface IScalablePane
extends ScalableFigure {
    public boolean useScaledGraphics();

    public boolean optimizeClip();

    default public Rectangle getScaledRect(Rectangle rect) {
        double scale = this.getScale();
        rect.scale(1.0 / scale);
        return rect;
    }

    public static final class IScalablePaneHelper {
        static Graphics prepareScaledGraphics(Graphics graphics, IScalablePane figurePane) {
            Graphics graphicsToUse;
            Graphics graphics2 = graphicsToUse = figurePane.useScaledGraphics() ? new ScaledGraphics(graphics) : graphics;
            if (!figurePane.optimizeClip()) {
                graphicsToUse.clipRect(figurePane.getBounds().getShrinked(figurePane.getInsets()));
            }
            graphicsToUse.scale(figurePane.getScale());
            graphicsToUse.pushState();
            return graphicsToUse;
        }

        static void cleanupScaledGraphics(Graphics graphics, Graphics graphicsUsed) {
            graphicsUsed.popState();
            if (graphicsUsed != graphics) {
                graphicsUsed.dispose();
            }
            graphics.restoreState();
        }

        private IScalablePaneHelper() {
            throw new UnsupportedOperationException("Helper class IScalablePaneHelper should not be instantiated");
        }
    }
}

