/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher;

import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.internal.docker.launcher.GdbDebuggerPage;
import org.eclipse.cdt.internal.docker.launcher.ILaunchConstants;
import org.eclipse.cdt.internal.docker.launcher.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RemoteDebuggerPage
extends GdbDebuggerPage {
    protected Text fGDBServerCommandText;
    protected Text fGDBServerPortNumberText;
    protected Button fRemoteTimeoutEnabledCheckbox;
    protected Text fRemoteTimeoutValueText;

    @Override
    public String getName() {
        return Messages.Remote_GDB_Debugger_Options;
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute(ILaunchConstants.ATTR_GDBSERVER_COMMAND, "gdbserver");
        configuration.setAttribute(ILaunchConstants.ATTR_GDBSERVER_PORT, "2345");
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TIMEOUT_ENABLED", LaunchUtils.getRemoteTimeoutEnabledDefault());
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TIMEOUT_VALUE", LaunchUtils.getRemoteTimeoutValueDefault());
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        String gdbserverCommand = null;
        String gdbserverPortNumber = null;
        boolean remoteTimeoutEnabled = false;
        String remoteTimeoutValue = null;
        try {
            gdbserverCommand = configuration.getAttribute(ILaunchConstants.ATTR_GDBSERVER_COMMAND, "gdbserver");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        try {
            gdbserverPortNumber = configuration.getAttribute(ILaunchConstants.ATTR_GDBSERVER_PORT, "2345");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        try {
            remoteTimeoutEnabled = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TIMEOUT_ENABLED", LaunchUtils.getRemoteTimeoutEnabledDefault());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        try {
            remoteTimeoutValue = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TIMEOUT_VALUE", LaunchUtils.getRemoteTimeoutValueDefault());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.fGDBServerCommandText.setText(gdbserverCommand);
        this.fGDBServerPortNumberText.setText(gdbserverPortNumber);
        this.fRemoteTimeoutEnabledCheckbox.setSelection(remoteTimeoutEnabled);
        this.fRemoteTimeoutValueText.setText(remoteTimeoutValue);
        this.remoteTimeoutEnabledChanged();
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        String str = this.fGDBServerCommandText.getText();
        str.trim();
        configuration.setAttribute(ILaunchConstants.ATTR_GDBSERVER_COMMAND, str);
        str = this.fGDBServerPortNumberText.getText();
        str.trim();
        configuration.setAttribute(ILaunchConstants.ATTR_GDBSERVER_PORT, str);
        boolean b = this.fRemoteTimeoutEnabledCheckbox.getSelection();
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TIMEOUT_ENABLED", b);
        str = this.fRemoteTimeoutValueText.getText();
        str.trim();
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TIMEOUT_VALUE", str);
    }

    protected void createGdbserverSettingsTab(CTabFolder tabFolder) {
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(Messages.Gdbserver_Settings_Tab_Name);
        Composite comp = new Composite((Composite)tabFolder, 0);
        comp.setLayout((Layout)new GridLayout(1, true));
        comp.setLayoutData((Object)new GridData(1808));
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        comp.setFont(tabFolder.getFont());
        tabItem.setControl((Control)comp);
        Composite subComp = new Composite(comp, 0);
        subComp.setLayout((Layout)new GridLayout(2, true));
        subComp.setLayoutData((Object)new GridData(1808));
        ((GridLayout)subComp.getLayout()).makeColumnsEqualWidth = false;
        subComp.setFont(tabFolder.getFont());
        Label label = new Label(subComp, 16384);
        label.setText(Messages.Gdbserver_name_textfield_label);
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        this.fGDBServerCommandText = new Text(subComp, 2052);
        GridData data = new GridData(4, 128, true, false);
        this.fGDBServerCommandText.setLayoutData((Object)data);
        this.fGDBServerCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                RemoteDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        label = new Label(subComp, 16384);
        label.setText(Messages.Port_number_textfield_label);
        gd = new GridData();
        label.setLayoutData((Object)gd);
        this.fGDBServerPortNumberText = new Text(subComp, 2052);
        data = new GridData(4, 128, true, false);
        this.fGDBServerPortNumberText.setLayoutData((Object)data);
        this.fGDBServerPortNumberText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                RemoteDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.fRemoteTimeoutEnabledCheckbox = new Button(subComp, 32);
        this.fRemoteTimeoutEnabledCheckbox.setText(Messages.Gdbserver_Settings_Remotetimeout_label);
        this.fRemoteTimeoutEnabledCheckbox.setToolTipText(Messages.Gdbserver_Settings_Remotetimeout_tooltip);
        gd = new GridData();
        this.fRemoteTimeoutEnabledCheckbox.setLayoutData((Object)gd);
        this.fRemoteTimeoutEnabledCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteDebuggerPage.this.remoteTimeoutEnabledChanged();
                RemoteDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.fRemoteTimeoutValueText = new Text(subComp, 2052);
        data = new GridData(4, 128, true, false);
        this.fRemoteTimeoutValueText.setLayoutData((Object)data);
        this.fRemoteTimeoutValueText.setToolTipText(Messages.Gdbserver_Settings_Remotetimeout_tooltip);
        this.fRemoteTimeoutValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                RemoteDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.remoteTimeoutEnabledChanged();
    }

    private void remoteTimeoutEnabledChanged() {
        this.fRemoteTimeoutValueText.setEnabled(this.fRemoteTimeoutEnabledCheckbox.getSelection());
    }

    @Override
    public void createTabs(CTabFolder tabFolder) {
        super.createTabs(tabFolder);
        this.createGdbserverSettingsTab(tabFolder);
    }
}

