/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors.automake;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;

public class WordPartDetector {
    String wordPart = "";
    int offset;

    public WordPartDetector(ITextViewer viewer, int documentOffset) {
        this(viewer.getDocument(), documentOffset);
    }

    public WordPartDetector(IDocument doc, int documentOffset) {
        this.offset = documentOffset - 1;
        int endOffset = documentOffset;
        try {
            IRegion region = doc.getLineInformationOfOffset(documentOffset);
            int top = region.getOffset();
            int bottom = region.getLength() + top;
            while (this.offset >= top && this.isMakefileLetter(doc.getChar(this.offset))) {
                --this.offset;
            }
            while (endOffset < bottom && this.isMakefileLetter(doc.getChar(endOffset))) {
                ++endOffset;
            }
            ++this.offset;
            this.wordPart = doc.get(this.offset, endOffset - this.offset);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static boolean inMacro(ITextViewer viewer, int offset) {
        return WordPartDetector.inMacro(viewer.getDocument(), offset);
    }

    public static boolean inMacro(IDocument document, int offset) {
        boolean isMacro = false;
        try {
            int index = offset - 1;
            while (index >= 0) {
                char c = document.getChar(index);
                if (c == '$') {
                    isMacro = true;
                } else if (!Character.isWhitespace(c)) {
                    --index;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return isMacro;
    }

    public String toString() {
        return this.wordPart;
    }

    public int getOffset() {
        return this.offset;
    }

    boolean isMakefileLetter(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == '.';
    }
}

