/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.core.configure;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.autotools.core.configure.AbstractConfigurationOption;
import org.eclipse.cdt.internal.autotools.core.configure.AutotoolsConfiguration;
import org.eclipse.cdt.internal.autotools.core.configure.IConfigureOption;
import org.eclipse.cdt.internal.autotools.core.configure.IFlagConfigureValueOption;

public class FlagConfigureOption
extends AbstractConfigurationOption {
    private String value;
    private ArrayList<String> children = new ArrayList();

    public FlagConfigureOption(String name, AutotoolsConfiguration cfg) {
        super(name, cfg);
        this.value = name;
    }

    public FlagConfigureOption(String name, String msgName, AutotoolsConfiguration cfg) {
        super(name, msgName, cfg);
        this.value = name;
    }

    private FlagConfigureOption(String name, AutotoolsConfiguration cfg, String value, ArrayList<String> children) {
        super(name, cfg);
        this.value = value;
        this.children = new ArrayList<String>(children);
    }

    @Override
    public String getParameter() {
        StringBuilder parms = new StringBuilder();
        String[] flagNames = this.getValue().split("\\|");
        String flagSeparator = "";
        String[] stringArray = flagNames;
        int n = flagNames.length;
        int n2 = 0;
        while (n2 < n) {
            String flagName = stringArray[n2];
            parms.append(flagSeparator);
            flagSeparator = " ";
            StringBuilder parm = new StringBuilder(flagName).append("=\"");
            boolean haveParm = false;
            if (this.isParmSet()) {
                String separator = "";
                int i = 0;
                while (i < this.children.size()) {
                    String fvname = this.children.get(i);
                    IConfigureOption o = this.cfg.getOption(fvname);
                    if (o.isParmSet() && o instanceof IFlagConfigureValueOption) {
                        parm.append(separator).append(((IFlagConfigureValueOption)((Object)o)).getFlags());
                        separator = " ";
                        haveParm = true;
                    }
                    ++i;
                }
                if (haveParm) {
                    parm.append('\"');
                    parms.append((CharSequence)parm);
                }
            }
            ++n2;
        }
        return parms.toString();
    }

    @Override
    public String getParameterName() {
        return this.getName();
    }

    @Override
    public boolean isParmSet() {
        int i = 0;
        while (i < this.children.size()) {
            String s = this.children.get(i);
            IConfigureOption o = this.cfg.getOption(s);
            if (o.isParmSet()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public IConfigureOption copy(AutotoolsConfiguration config) {
        return new FlagConfigureOption(this.name, config, this.value, this.children);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public boolean isFlag() {
        return true;
    }

    public void addChild(String name) {
        this.children.add(name);
    }

    public List<String> getChildren() {
        return this.children;
    }
}

