/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.debug.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.debug.model.AbstractDebugElement;
import org.eclipse.acceleo.internal.ide.ui.debug.model.AcceleoVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.graphics.Image;

public class AcceleoValue
extends AbstractDebugElement
implements IValue {
    private Object value;
    private int type;

    public AcceleoValue(IDebugTarget target, Object value, int type) {
        super(target);
        this.value = value;
        this.type = type;
    }

    public Image getImage() throws DebugException {
        Image ret = null;
        if (this.type == 1) {
            ret = AcceleoUIActivator.getDefault().getImage("icons/debug/class.gif");
        } else if (this.type == 3) {
            ret = AcceleoUIActivator.getDefault().getImage("icons/debug/attribute.gif");
        } else if (this.type == 2) {
            ret = AcceleoUIActivator.getDefault().getImage("icons/debug/reference.gif");
        } else if (this.value instanceof Boolean) {
            ret = AcceleoUIActivator.getDefault().getImage("icons/debug/boolean.gif");
        } else if (this.value instanceof Double) {
            ret = AcceleoUIActivator.getDefault().getImage("icons/debug/double.gif");
        } else if (this.value instanceof EObject) {
            ret = AcceleoUIActivator.getDefault().getImage("icons/debug/class.gif");
        } else if (this.value instanceof Integer) {
            ret = AcceleoUIActivator.getDefault().getImage("icons/debug/int.gif");
        } else if (this.value instanceof String) {
            ret = AcceleoUIActivator.getDefault().getImage("icons/debug/string.gif");
        } else if (this.value instanceof List) {
            ret = AcceleoUIActivator.getDefault().getImage("icons/debug/list.gif");
        } else if (this.value == null) {
            ret = AcceleoUIActivator.getDefault().getImage("icons/debug/null.gif");
        }
        return ret;
    }

    public String getReferenceTypeName() throws DebugException {
        String ret = "";
        if (this.value != null) {
            ret = this.value instanceof EObject ? ((EObject)this.value).eClass().getName() : this.value.getClass().getName().substring(this.value.getClass().getName().lastIndexOf(46) + 1);
        }
        return ret;
    }

    public String getValueString() throws DebugException {
        String ret = "";
        if (this.value != null) {
            if (this.value instanceof EObject) {
                EObject eObject = (EObject)this.value;
                ret = this.getEObjectValue(eObject);
            } else {
                ret = this.value instanceof Collection ? this.toSimpleString((Collection)this.value) : this.value.toString();
            }
        }
        return ret;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        IVariable[] ret = null;
        ret = this.value != null ? (this.value instanceof EObject ? this.computeEObjectVariables((EObject)this.value) : (this.value instanceof Collection ? this.computeCollectionVariables((Collection)this.value) : this.computeVariables(this.value))) : new IVariable[]{};
        return ret;
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables().length > 0;
    }

    private IVariable[] computeEObjectVariables(EObject object) {
        ArrayList<AcceleoVariable> variables = new ArrayList<AcceleoVariable>();
        EList structuralFeatures = object.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature currentFeature : structuralFeatures) {
            String featureName = currentFeature.getName();
            Object featureValue = object.eGet(currentFeature);
            int referenceType = currentFeature instanceof EReference ? 2 : 3;
            if ((!(featureValue instanceof Collection) || ((Collection)featureValue).size() <= 0) && (featureValue instanceof Collection || featureValue == null)) continue;
            variables.add(new AcceleoVariable(this.getDebugTarget(), featureName, featureValue, referenceType));
        }
        return variables.toArray(new IVariable[variables.size()]);
    }

    private IVariable[] computeCollectionVariables(Collection<?> collection) throws DebugException {
        ArrayList<IVariable> variables = new ArrayList<IVariable>();
        for (Object element : collection) {
            if (element instanceof EObject) {
                variables.add(this.eObjectToVariable((EObject)element));
                continue;
            }
            if (element instanceof Collection) {
                variables.add(new AcceleoVariable(this.getDebugTarget(), this.toSimpleString((Collection)element), element, 0));
                continue;
            }
            variables.add(new AcceleoVariable(this.getDebugTarget(), "" + element, element, 0));
        }
        return variables.toArray(new IVariable[variables.size()]);
    }

    private IVariable[] computeVariables(Object object) {
        ArrayList variables = new ArrayList();
        return variables.toArray(new IVariable[variables.size()]);
    }

    private IVariable eObjectToVariable(EObject eObject) {
        String variableName = eObject.eClass().getName();
        return new AcceleoVariable(this.getDebugTarget(), variableName, (Object)eObject, 1);
    }

    private String getEObjectValue(EObject eObject) {
        String variableName = eObject.eClass().getName();
        EStructuralFeature feature = eObject.eClass().getEStructuralFeature("name");
        if (feature != null) {
            Object variableNameObject = eObject.eGet(feature);
            String variableValue = variableNameObject != null ? variableNameObject.toString() : "";
            variableName = String.valueOf(variableName) + ':' + variableValue;
        }
        return variableName;
    }

    private String toSimpleString(Collection<?> collection) {
        ArrayList<String> strings = new ArrayList<String>(collection.size());
        for (Object currentValue : collection) {
            if (currentValue instanceof EObject) {
                EObject eObject = (EObject)currentValue;
                String typeName = eObject.eClass().getName();
                String label = "";
                EStructuralFeature structuralFeature = eObject.eClass().getEStructuralFeature("name");
                if (structuralFeature != null) {
                    Object nameObject = eObject.eGet(structuralFeature);
                    label = nameObject != null ? nameObject.toString() : "";
                }
                strings.add(String.valueOf(typeName) + ':' + label);
                continue;
            }
            if (currentValue instanceof Collection) {
                strings.add("Collection");
                continue;
            }
            String typeName = currentValue.getClass().getName().substring(currentValue.getClass().getName().lastIndexOf(46) + 1);
            String label = currentValue.toString();
            strings.add(String.valueOf(typeName) + ':' + label);
        }
        StringBuffer buffer = new StringBuffer("[");
        Iterator iterStrings = strings.iterator();
        boolean first = true;
        while (iterStrings.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append((String)iterStrings.next());
        }
        buffer.append(']');
        return buffer.toString();
    }
}

