/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.Logger;
import org.eclipse.wst.jsdt.internal.core.index.EntryResult;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.matching.VariablePattern;
import org.eclipse.wst.jsdt.internal.core.util.QualificationHelpers;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class FieldPattern
extends VariablePattern {
    private char[][] declaringQualification;
    private char[][] declaringSimpleName;
    public char[] typeQualification;
    public char[] typeSimpleName;
    public int modifiers;
    protected static char[][] REF_CATEGORIES = new char[][]{REF};
    protected static char[][] REF_AND_DECL_CATEGORIES = new char[][]{REF, FIELD_DECL, VAR_DECL};
    protected static char[][] DECL_CATEGORIES = new char[][]{FIELD_DECL, VAR_DECL};
    protected boolean isVar;

    public static char[] createIndexKey(char[] fieldName, char[] typeName, char[] declaringType, int modifiers) {
        char[] indexKey = null;
        if (fieldName != null && fieldName.length > 0) {
            int typeNameLength = typeName == null ? 0 : typeName.length;
            int declaringTypeLength = declaringType == null ? 0 : declaringType.length;
            int resultLength = fieldName.length + 1 + typeNameLength + 1 + declaringTypeLength + 3;
            indexKey = new char[resultLength];
            int pos = 0;
            System.arraycopy(fieldName, 0, indexKey, pos, fieldName.length);
            pos += fieldName.length;
            indexKey[pos++] = 47;
            if (declaringTypeLength > 0) {
                System.arraycopy(declaringType, 0, indexKey, pos, declaringTypeLength);
                pos += declaringTypeLength;
            }
            indexKey[pos++] = 47;
            if (typeNameLength > 0) {
                System.arraycopy(typeName, 0, indexKey, pos, typeNameLength);
                pos += typeNameLength;
            }
            indexKey[pos++] = 47;
            indexKey[pos++] = (char)modifiers;
            indexKey[pos++] = (char)(modifiers >> 16);
        }
        return indexKey;
    }

    public FieldPattern(boolean findDeclarations, boolean readAccess, boolean writeAccess, boolean isVar, char[] name, char[][] possibleDeclaringTypes, char[] typeQualification, char[] typeSimpleName, int matchRule, IField field) {
        super(64, findDeclarations, readAccess, writeAccess, name, matchRule, field);
        this.isVar = isVar;
        if (possibleDeclaringTypes != null) {
            this.declaringQualification = new char[possibleDeclaringTypes.length][];
            this.declaringSimpleName = new char[possibleDeclaringTypes.length][];
            int i = 0;
            while (i < possibleDeclaringTypes.length) {
                char[][] seperatedDeclaringType = QualificationHelpers.seperateFullyQualifedName(possibleDeclaringTypes[i]);
                this.declaringQualification[i] = this.isCaseSensitive() ? seperatedDeclaringType[0] : CharOperation.toLowerCase(seperatedDeclaringType[0]);
                this.declaringSimpleName[i] = this.isCaseSensitive() ? seperatedDeclaringType[1] : CharOperation.toLowerCase(seperatedDeclaringType[1]);
                ++i;
            }
        }
        this.typeQualification = this.isCaseSensitive() ? typeQualification : CharOperation.toLowerCase(typeQualification);
        this.typeSimpleName = this.isCaseSensitive() || this.isCamelCase() ? typeSimpleName : CharOperation.toLowerCase(typeSimpleName);
        this.mustResolve = this.mustResolve();
    }

    public FieldPattern(boolean findDeclarations, boolean readAccess, boolean writeAccess, char[] name, char[] declaringQualification, char[] declaringSimpleName, int matchRule) {
        this(findDeclarations, readAccess, writeAccess, false, name, declaringQualification, declaringSimpleName, null, null, matchRule, null);
    }

    public FieldPattern(boolean findDeclarations, boolean readAccess, boolean writeAccess, boolean isVar, char[] name, char[] declaringQualification, char[] declaringSimpleName, char[] typeQualification, char[] typeSimpleName, int matchRule, IField field) {
        super(64, findDeclarations, readAccess, writeAccess, name, matchRule, field);
        this.isVar = isVar;
        this.setDeclaringQualification(declaringQualification);
        this.setDeclaringSimpleName(declaringSimpleName);
        this.typeQualification = this.isCaseSensitive() ? typeQualification : CharOperation.toLowerCase(typeQualification);
        this.typeSimpleName = this.isCaseSensitive() || this.isCamelCase() ? typeSimpleName : CharOperation.toLowerCase(typeSimpleName);
        this.mustResolve = this.mustResolve();
    }

    @Override
    public void decodeIndexKey(char[] key) {
        char[][] separated = CharOperation.splitOn('/', key);
        this.name = separated[0];
        if (separated.length > 1 && separated.length <= 4) {
            char[][] declaringType = QualificationHelpers.seperateFullyQualifedName(separated[1]);
            this.setDeclaringQualification(declaringType[0]);
            this.setDeclaringSimpleName(declaringType[1]);
            char[][] type = QualificationHelpers.seperateFullyQualifedName(separated[2]);
            this.typeQualification = type[0];
            this.typeSimpleName = type[1];
            this.modifiers = separated[3][0] + separated[3][1];
        } else if (separated.length > 4) {
            Util.verbose("Error decoding index key; " + new String(key) + "\n\t Key contains separator character.");
            return;
        }
    }

    @Override
    public SearchPattern getBlankPattern() {
        return new FieldPattern(false, false, false, this.isVar, null, null, null, null, 8, null);
    }

    @Override
    public char[] getIndexKey() {
        return this.name;
    }

    @Override
    EntryResult[] queryIn(Index index) throws IOException {
        EntryResult[] results = null;
        char[][] keys = null;
        int[] matchRules = null;
        if (this.findReferences && (this.findDeclarations || this.writeAccess)) {
            keys = new char[2][];
            matchRules = new int[2];
        } else {
            keys = new char[1][];
            matchRules = new int[1];
        }
        keys[0] = this.name;
        matchRules[0] = this.getMatchRule();
        if (this.findDeclarations || this.writeAccess) {
            switch (this.getMatchMode()) {
                case 0: {
                    if (this.isCamelCase) break;
                    keys[0] = CharOperation.concat(this.name, QualificationHelpers.createFullyQualifiedName(this.getDeclaringQualification(), this.getDeclaringSimpleName()), '/');
                    keys[0] = CharOperation.append(keys[0], '/');
                    matchRules[0] = matchRules[0] & 0xFFFFFFFF;
                    matchRules[0] = matchRules[0] | 1;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    keys[0] = FieldPattern.createSearchIndexKey(this.name, this.getDeclaringQualification(), this.getDeclaringSimpleName());
                    break;
                }
                case 4: {
                    Logger.log(2, "Regular expression matching is not yet implimented for MethodPattern");
                }
            }
        }
        if (this.findReferences && (this.findDeclarations || this.writeAccess)) {
            keys[1] = this.name;
            matchRules[1] = this.getMatchRule();
        }
        int i = 0;
        while (i < keys.length) {
            EntryResult[] additionalResults = index.query(this.getIndexCategories(), keys[i], matchRules[i]);
            if (additionalResults != null && additionalResults.length > 0) {
                if (results == null) {
                    results = additionalResults;
                } else {
                    EntryResult[] existingResults = results;
                    results = new EntryResult[existingResults.length + additionalResults.length];
                    System.arraycopy(existingResults, 0, results, 0, existingResults.length);
                    System.arraycopy(additionalResults, 0, results, existingResults.length, additionalResults.length);
                }
            }
            ++i;
        }
        return results;
    }

    @Override
    public char[][] getIndexCategories() {
        if (this.findReferences) {
            return this.findDeclarations || this.writeAccess ? REF_AND_DECL_CATEGORIES : REF_CATEGORIES;
        }
        if (this.findDeclarations) {
            return DECL_CATEGORIES;
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    @Override
    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        boolean matches = false;
        if (decodedPattern instanceof FieldPattern) {
            FieldPattern pattern = (FieldPattern)decodedPattern;
            matches = this.matchesName(this.name, pattern.name);
            if (matches && this.declaringSimpleName != null) {
                boolean foundTypeMatch = false;
                int i = 0;
                while (i < this.declaringSimpleName.length) {
                    if (this.matchesName(this.declaringQualification[i], pattern.getDeclaringQualification()) && this.matchesName(this.declaringSimpleName[i], pattern.getDeclaringSimpleName())) {
                        foundTypeMatch = true;
                        break;
                    }
                    ++i;
                }
                if (!foundTypeMatch) {
                    matches = false;
                }
            }
        }
        return matches;
    }

    public char[] getDeclaringQualification() {
        return this.declaringQualification != null && this.declaringQualification.length > 0 ? this.declaringQualification[0] : null;
    }

    public char[] getDeclaringSimpleName() {
        return this.declaringSimpleName != null && this.declaringSimpleName.length > 0 ? this.declaringSimpleName[0] : null;
    }

    private void setDeclaringQualification(char[] declaringQualification) {
        this.declaringQualification = new char[1][];
        this.declaringQualification[0] = declaringQualification;
    }

    private void setDeclaringSimpleName(char[] declaringSimpleName) {
        this.declaringSimpleName = new char[1][];
        this.declaringSimpleName[0] = declaringSimpleName;
    }

    @Override
    protected boolean mustResolve() {
        return !this.isVar && this.findDeclarations;
    }

    @Override
    protected StringBuffer print(StringBuffer output) {
        if (this.findDeclarations) {
            output.append(this.findReferences ? "FieldCombinedPattern: " : "FieldDeclarationPattern: ");
        } else {
            output.append("FieldReferencePattern: ");
        }
        if (this.getDeclaringQualification() != null) {
            output.append(this.getDeclaringQualification()).append('.');
        }
        if (this.getDeclaringSimpleName() != null) {
            output.append(this.getDeclaringSimpleName()).append('.');
        } else if (this.getDeclaringSimpleName() != null) {
            output.append("*.");
        }
        if (this.name == null) {
            output.append("*");
        } else {
            output.append(this.name);
        }
        if (this.typeQualification != null) {
            output.append(" --> ").append(this.typeQualification).append('.');
        } else if (this.typeSimpleName != null) {
            output.append(" --> ");
        }
        if (this.typeSimpleName != null) {
            output.append(this.typeSimpleName);
        } else if (this.typeQualification != null) {
            output.append("*");
        }
        return super.print(output);
    }

    private static char[] createSearchIndexKey(char[] name, char[] declaringQualification, char[] declaringSimpleName) {
        char[] declaringFullTypeName = null;
        if (declaringSimpleName != null) {
            declaringFullTypeName = QualificationHelpers.createFullyQualifiedName(declaringQualification, declaringSimpleName);
        }
        return FieldPattern.createIndexKey(name, ONE_STAR, declaringFullTypeName != null ? declaringFullTypeName : ONE_STAR, 0);
    }
}

