/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.model;

import com.jgoodies.forms.layout.CellConstraints;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.editor.constants.CoreImages;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.swing.FormLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.ModelMessages;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;

public class SelectionActionsSupport
extends ObjectEventListener {
    private final FormLayoutInfo m_layout;

    public SelectionActionsSupport(FormLayoutInfo layout) {
        this.m_layout = layout;
        this.m_layout.addBroadcastListener((Object)this);
    }

    public void addSelectionActions(List<ObjectInfo> objects, List<Object> actions) throws Exception {
        if (objects.isEmpty()) {
            return;
        }
        ArrayList<CellConstraintsSupport> constraints = new ArrayList<CellConstraintsSupport>();
        for (ObjectInfo object : objects) {
            ComponentInfo component;
            block6: {
                block5: {
                    if (!(object instanceof ComponentInfo)) break block5;
                    component = (ComponentInfo)object;
                    if (object.getParent() == this.m_layout.getContainer()) break block6;
                }
                return;
            }
            constraints.add(FormLayoutInfo.getConstraints(component));
        }
        actions.add(new Separator());
        this.addAlignmentAction(actions, constraints, true, CoreImages.ALIGNMENT_H_MENU_DEFAULT, ModelMessages.SelectionActionsSupport_haDefault, CellConstraints.DEFAULT);
        this.addAlignmentAction(actions, constraints, true, CoreImages.ALIGNMENT_H_MENU_LEFT, ModelMessages.SelectionActionsSupport_haLeft, CellConstraints.LEFT);
        this.addAlignmentAction(actions, constraints, true, CoreImages.ALIGNMENT_H_MENU_CENTER, ModelMessages.SelectionActionsSupport_haCenter, CellConstraints.CENTER);
        this.addAlignmentAction(actions, constraints, true, CoreImages.ALIGNMENT_H_MENU_RIGHT, ModelMessages.SelectionActionsSupport_haRight, CellConstraints.RIGHT);
        this.addAlignmentAction(actions, constraints, true, CoreImages.ALIGNMENT_H_MENU_FILL, ModelMessages.SelectionActionsSupport_haFill, CellConstraints.FILL);
        actions.add(new Separator());
        this.addAlignmentAction(actions, constraints, false, CoreImages.ALIGNMENT_V_MENU_DEFAULT, ModelMessages.SelectionActionsSupport_vaDefault, CellConstraints.DEFAULT);
        this.addAlignmentAction(actions, constraints, false, CoreImages.ALIGNMENT_V_MENU_TOP, ModelMessages.SelectionActionsSupport_haTop, CellConstraints.TOP);
        this.addAlignmentAction(actions, constraints, false, CoreImages.ALIGNMENT_V_MENU_CENTER, ModelMessages.SelectionActionsSupport_vaCenter, CellConstraints.CENTER);
        this.addAlignmentAction(actions, constraints, false, CoreImages.ALIGNMENT_V_MENU_BOTTOM, ModelMessages.SelectionActionsSupport_vaBottom, CellConstraints.BOTTOM);
        this.addAlignmentAction(actions, constraints, false, CoreImages.ALIGNMENT_V_MENU_FILL, ModelMessages.SelectionActionsSupport_vaFill, CellConstraints.FILL);
    }

    private void addAlignmentAction(List<Object> actions, List<CellConstraintsSupport> constraints, boolean horizontal, ImageDescriptor icon, String tooltip, CellConstraints.Alignment alignment) {
        boolean isChecked = true;
        for (CellConstraintsSupport constraint : constraints) {
            if (horizontal) {
                if (constraint.alignH == alignment) continue;
                isChecked = false;
                break;
            }
            if (constraint.alignV == alignment) continue;
            isChecked = false;
            break;
        }
        AlignmentAction action = new AlignmentAction(constraints, horizontal, icon, tooltip, isChecked, alignment);
        actions.add((Object)action);
    }

    private abstract class AbstractAction
    extends ObjectInfoAction {
        private final List<CellConstraintsSupport> m_constraints;
        private final boolean m_horizontal;

        public AbstractAction(int style, List<CellConstraintsSupport> constraints, boolean horizontal, ImageDescriptor icon, String tooltip, boolean checked) {
            super((ObjectInfo)SelectionActionsSupport.this.m_layout, "", style);
            this.m_constraints = constraints;
            this.m_horizontal = horizontal;
            this.setImageDescriptor(icon);
            this.setToolTipText(tooltip);
            this.setChecked(checked);
        }

        protected void runEx() throws Exception {
            for (CellConstraintsSupport constraint : this.m_constraints) {
                if (this.m_horizontal) {
                    this.handleHorizontal(constraint);
                } else {
                    this.handleVertical(constraint);
                }
                constraint.write();
            }
        }

        protected abstract void handleHorizontal(CellConstraintsSupport var1) throws Exception;

        protected abstract void handleVertical(CellConstraintsSupport var1) throws Exception;
    }

    private final class AlignmentAction
    extends AbstractAction {
        private final CellConstraints.Alignment m_alignment;

        public AlignmentAction(List<CellConstraintsSupport> constraints, boolean horizontal, ImageDescriptor icon, String tooltip, boolean checked, CellConstraints.Alignment alignment) {
            super(8, constraints, horizontal, icon, tooltip, checked);
            this.m_alignment = alignment;
        }

        @Override
        protected void handleHorizontal(CellConstraintsSupport constraint) throws Exception {
            constraint.alignH = this.m_alignment;
        }

        @Override
        protected void handleVertical(CellConstraintsSupport constraint) throws Exception {
            constraint.alignV = this.m_alignment;
        }
    }
}

