/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.eval;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;

public class EvaluationContext {
    private final ClassLoader m_classLoader;
    private final ExecutionFlowDescription m_flowDescription;
    private final List<IExpressionEvaluator> m_evaluators = new ArrayList<IExpressionEvaluator>();
    private Map<Object, Object> m_arbitraryMap;

    public EvaluationContext(ClassLoader classLoader, ExecutionFlowDescription flowDescription) {
        Assert.isNotNull((Object)classLoader);
        Assert.isNotNull((Object)flowDescription);
        this.m_classLoader = classLoader;
        this.m_flowDescription = flowDescription;
    }

    public ClassLoader getClassLoader() {
        return this.m_classLoader;
    }

    public final ExecutionFlowDescription getFlowDescription() {
        return this.m_flowDescription;
    }

    public String getSource(ASTNode node) {
        return node.toString();
    }

    public final List<IExpressionEvaluator> getEvaluators() {
        return this.m_evaluators;
    }

    public final void addEvaluator(IExpressionEvaluator evaluator) {
        this.m_evaluators.add(evaluator);
    }

    public final void removeEvaluator(IExpressionEvaluator evaluator) {
        this.m_evaluators.remove(evaluator);
    }

    public Object evaluate(Expression expression) throws Exception {
        return AstEvaluationEngine.UNKNOWN;
    }

    public Object evaluateUnknownParameter(MethodDeclaration methodDeclaration, SingleVariableDeclaration parameter) throws Exception {
        throw new DesignerException(304, new String[]{this.getSource((ASTNode)methodDeclaration), this.getSource((ASTNode)parameter)});
    }

    public void evaluationRequested(Expression expression) throws Exception {
    }

    public void evaluationSuccessful(Expression expression, Object value) throws Exception {
    }

    public Object evaluationFailed(Expression expression, Throwable e) throws Exception {
        return AstEvaluationEngine.UNKNOWN;
    }

    public void addException(ASTNode node, Throwable e) {
    }

    public final void putArbitraryValue(Object key, Object value) {
        if (this.m_arbitraryMap == null) {
            this.m_arbitraryMap = new HashMap<Object, Object>();
        }
        this.m_arbitraryMap.put(key, value);
    }

    public final Object getArbitraryValue(Object key) {
        if (this.m_arbitraryMap != null) {
            return this.m_arbitraryMap.get(key);
        }
        return null;
    }
}

