/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.resources;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.files.ui.resources.SystemTempFileListener;
import org.eclipse.rse.internal.files.ui.actions.SystemUploadConflictAction;
import org.eclipse.rse.internal.files.ui.resources.SystemRemoteEditManager;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.services.files.RemoteFileSecurityException;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.actions.DisplaySystemMessageAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class SystemUniversalTempFileListener
extends SystemTempFileListener {
    private static SystemUniversalTempFileListener _instance = null;
    private ArrayList _editedFiles = new ArrayList();

    public static SystemUniversalTempFileListener getListener() {
        if (_instance == null) {
            _instance = new SystemUniversalTempFileListener();
        }
        return _instance;
    }

    public void registerEditedFile(SystemEditableRemoteFile editMember) {
        this._editedFiles.add(editMember);
    }

    public void unregisterEditedFile(SystemEditableRemoteFile editMember) {
        this._editedFiles.remove(editMember);
    }

    public SystemEditableRemoteFile getEditedFile(IRemoteFile file) {
        int i = 0;
        while (i < this._editedFiles.size()) {
            IRemoteFile editedFile;
            SystemEditableRemoteFile efile = (SystemEditableRemoteFile)this._editedFiles.get(i);
            if (efile != null && (editedFile = efile.getRemoteFile()).getAbsolutePathPlusConnection().equals(file.getAbsolutePathPlusConnection())) {
                return efile;
            }
            ++i;
        }
        return null;
    }

    protected boolean doesHandle(ISubSystem subsystem) {
        return subsystem instanceof IRemoteFileSubSystem;
    }

    protected void doResourceSynchronization(ISubSystem subsystem, IFile tempFile, String resourceId, IProgressMonitor monitor) {
        if (subsystem instanceof IRemoteFileSubSystem) {
            IRemoteFileSubSystem fs = (IRemoteFileSubSystem)subsystem;
            SystemIFileProperties properties = new SystemIFileProperties((IResource)tempFile);
            if (fs.isOffline() || !fs.isConnected()) {
                properties.setDirty(true);
                SystemEditableRemoteFile editable = null;
                if (properties.getRemoteFileObject() instanceof SystemEditableRemoteFile) {
                    editable = (SystemEditableRemoteFile)properties.getRemoteFileObject();
                    editable.updateDirtyIndicator();
                }
                return;
            }
            boolean isMounted = properties.getRemoteFileMounted();
            if (isMounted) {
                String mappedHostPath = properties.getResolvedMountedRemoteFilePath();
                String mappedHostName = properties.getResolvedMountedRemoteFileHost();
                String systemRemotePath = SystemRemoteEditManager.getInstance().getMountPathFor(mappedHostName, mappedHostPath, (IRemoteFileSubSystem)subsystem);
                if (systemRemotePath == null) {
                    return;
                }
                if (!systemRemotePath.equals(resourceId)) {
                    resourceId = systemRemotePath;
                    properties.setRemoteFilePath(systemRemotePath);
                }
            }
            try {
                IRemoteFile remoteFile = fs.getRemoteFileObject(resourceId, monitor);
                if (remoteFile != null) {
                    remoteFile.markStale(true);
                    remoteFile = fs.getRemoteFileObject(resourceId, monitor);
                    long storedModifiedStamp = properties.getRemoteFileTimeStamp();
                    if (remoteFile.exists() && !remoteFile.canWrite() && !tempFile.isReadOnly()) {
                        IRemoteFileSubSystem ss = remoteFile.getParentRemoteFileSubSystem();
                        ss.setReadOnly(remoteFile, false, monitor);
                        if (!remoteFile.canWrite()) {
                            remoteFile.markStale(true);
                            remoteFile = ss.getRemoteFileObject(remoteFile.getAbsolutePath(), monitor);
                        }
                    }
                    boolean openEditorAfterUpload = false;
                    SystemEditableRemoteFile editable = this.getEditedFile(remoteFile);
                    if (editable != null && storedModifiedStamp == 0L) {
                        return;
                    }
                    if (editable == null) {
                        Object remoteObject = properties.getRemoteFileObject();
                        editable = remoteObject != null && remoteObject instanceof SystemEditableRemoteFile ? (SystemEditableRemoteFile)remoteObject : new SystemEditableRemoteFile(remoteFile);
                        openEditorAfterUpload = true;
                        editable.setLocalResourceProperties();
                    }
                    this.upload(fs, remoteFile, tempFile, properties, storedModifiedStamp, editable, monitor);
                    if (openEditorAfterUpload) {
                        final SystemEditableRemoteFile fEditable = editable;
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                if (fEditable.checkOpenInEditor() != -1) {
                                    try {
                                        fEditable.openEditor();
                                    }
                                    catch (PartInitException partInitException) {
                                        // empty catch block
                                    }
                                }
                                fEditable.addAsListener();
                            }
                        });
                    }
                }
            }
            catch (SystemMessageException e) {
                DisplaySystemMessageAction msgAction = new DisplaySystemMessageAction(e.getSystemMessage());
                Display.getDefault().syncExec((Runnable)msgAction);
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)e.getMessage());
            }
        }
    }

    public void upload(IRemoteFileSubSystem fs, IRemoteFile remoteFile, IFile tempFile, SystemIFileProperties properties, long storedModifiedStamp, SystemEditableRemoteFile editable, IProgressMonitor monitor) {
        block12: {
            try {
                boolean remoteFileDeleted;
                long remoteModifiedStamp = remoteFile.getLastModified();
                boolean bl = remoteFileDeleted = !remoteFile.exists();
                if (remoteFileDeleted || storedModifiedStamp == remoteModifiedStamp) {
                    DisplaySystemMessageAction msgAction;
                    try {
                        String srcEncoding = tempFile.getCharset(true);
                        if (srcEncoding == null) {
                            srcEncoding = remoteFile.getEncoding();
                        }
                        fs.upload(tempFile.getLocation().makeAbsolute().toOSString(), remoteFile, srcEncoding, monitor);
                    }
                    catch (RemoteFileSecurityException e) {
                        msgAction = new DisplaySystemMessageAction(e.getSystemMessage());
                        Display.getDefault().syncExec((Runnable)msgAction);
                    }
                    catch (RemoteFileIOException e) {
                        msgAction = new DisplaySystemMessageAction(e.getSystemMessage());
                        Display.getDefault().syncExec((Runnable)msgAction);
                    }
                    catch (Exception e) {
                        RemoteFileIOException exc = new RemoteFileIOException(e);
                        DisplaySystemMessageAction msgAction2 = new DisplaySystemMessageAction(exc.getSystemMessage());
                        Display.getDefault().syncExec((Runnable)msgAction2);
                    }
                    remoteFile.markStale(true);
                    remoteFile = fs.getRemoteFileObject(remoteFile.getAbsolutePath(), monitor);
                    IRemoteFile parent = remoteFile.getParentRemoteFile();
                    long ts = remoteFile.getLastModified();
                    properties.setRemoteFileTimeStamp(ts);
                    ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
                    if (parent != null) {
                        registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)parent, 82, null));
                    }
                    registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)remoteFile, 86, (Object)remoteFile));
                    properties.setDirty(false);
                    if (editable.isDirty()) {
                        editable.updateDirtyIndicator();
                    }
                    break block12;
                }
                if (storedModifiedStamp == -1L) {
                    properties.setRemoteFileTimeStamp(remoteFile.getLastModified());
                } else {
                    final boolean remoteNewer = remoteModifiedStamp > storedModifiedStamp;
                    final SystemEditableRemoteFile remoteEdit = editable;
                    final IFile tFile = tempFile;
                    final IRemoteFile rFile = remoteFile;
                    final SystemIFileProperties fProperties = properties;
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            boolean closing = PlatformUI.getWorkbench().isClosing();
                            Shell shell = null;
                            shell = closing ? Display.getDefault().getActiveShell() : RSEUIPlugin.getTheSystemRegistryUI().getShell();
                            SystemUploadConflictAction conflictAction = new SystemUploadConflictAction(shell, tFile, rFile, remoteNewer);
                            conflictAction.run();
                            if (fProperties.getDirty()) {
                                remoteEdit.updateDirtyIndicator();
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

