/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.editor;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.internal.core.operations.GetBuildsOperation;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeEvent;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeListener;
import org.eclipse.mylyn.commons.workbench.EditorHandle;
import org.eclipse.mylyn.internal.builds.ui.editor.BuildEditor;
import org.eclipse.mylyn.internal.builds.ui.editor.BuildEditorInput;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class RefreshBuildEditorOperationListener
extends OperationChangeListener {
    private final IBuild build;
    private final EditorHandle handle;

    public RefreshBuildEditorOperationListener(IBuild build, EditorHandle handle) {
        this.build = build;
        this.handle = handle;
    }

    public void done(OperationChangeEvent event) {
        IBuildPlan plan = this.build.getPlan();
        String label = this.build.getLabel();
        if (event.getStatus().isOK() && !Display.getDefault().isDisposed()) {
            GetBuildsOperation operation = (GetBuildsOperation)event.getOperation();
            List builds = operation.getBuilds();
            if (builds != null && builds.size() > 0) {
                IBuild updatedBuild = (IBuild)builds.get(0);
                updatedBuild.setPlan(plan);
                updatedBuild.setServer(plan.getServer());
                this.updateBuildInfo(updatedBuild, BuildEditorInput.BuildInfo.COMPLETE);
            } else {
                Status status = new Status(4, "org.eclipse.mylyn.builds.ui", NLS.bind((String)"The requested build ''{0}'' was not found", (Object)label));
                this.handle.setStatus((IStatus)status);
                this.updateBuildInfo(this.build, BuildEditorInput.BuildInfo.ERROR);
            }
        } else {
            this.handle.setStatus(event.getStatus());
            this.updateBuildInfo(this.build, BuildEditorInput.BuildInfo.ERROR);
        }
    }

    private void updateBuildInfo(IBuild updatedBuild, BuildEditorInput.BuildInfo buildInfo) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            BuildEditor editor;
            if (this.handle.getPart() instanceof BuildEditor && this.shouldUpdate(editor = (BuildEditor)this.handle.getPart())) {
                editor.getEditorInput().updateBuildInfo(updatedBuild, buildInfo);
                editor.refresh();
            }
        });
    }

    private boolean shouldUpdate(BuildEditor editor) {
        return !editor.isDisposed() && !editor.getEditorSite().getWorkbenchWindow().getShell().isDisposed();
    }
}

