/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.util.ui.internal.exported.util.widget.component.properties;

import org.eclipse.modisco.facet.util.ui.internal.exported.PropertyElement;
import org.eclipse.modisco.facet.util.ui.internal.exported.util.widget.AbstractWidget;
import org.eclipse.modisco.facet.util.ui.utils.UIUtils;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractGetPropertyWidget
extends AbstractWidget {
    private static final int COLUMN_NUMBER = 2;
    private static final int WIDTH_HINT_DEF = 65;
    private int labelWidthHint;
    private final PropertyElement propertyElement;
    private Button propertyButton;

    protected AbstractGetPropertyWidget(Composite parent, PropertyElement propertyElement) {
        super(parent);
        this.propertyElement = propertyElement;
        this.labelWidthHint = 65;
        this.setLayout((Layout)new GridLayout(2, false));
        this.setLayoutData(new GridData(768));
    }

    @Override
    protected void addSubWidgets() {
        if (this.getLabel() != null && !"".equals(this.getLabel())) {
            Label label = UIUtils.createLabel(this, this.getLabel());
            GridData layoutData = new GridData(4);
            layoutData.widthHint = this.labelWidthHint;
            label.setLayoutData((Object)layoutData);
            label.setEnabled(this.propertyElement.isChangeable());
        }
        this.createCheckbox();
    }

    public void setPropertyEnabled(boolean enabled) {
        this.propertyButton.setSelection(enabled);
    }

    private void createCheckbox() {
        if (this.propertyElement.getValue() == null) {
            this.propertyElement.setValue(Boolean.TRUE);
        }
        SelectionListener selectionListener = null;
        if (this.propertyElement.isChangeable()) {
            selectionListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    AbstractGetPropertyWidget.this.onSelection((Button)event.getSource());
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            };
        }
        this.propertyButton = UIUtils.createCheckbox(this, this.propertyElement.isChangeable(), (Boolean)this.propertyElement.getValue(), selectionListener);
    }

    protected void onSelection(Button source) {
        this.propertyElement.setValue(source.getSelection());
    }

    protected abstract String getLabel();

    public void setLabelWidthHint(int labelWidthHint) {
        this.labelWidthHint = labelWidthHint;
    }

    public boolean isSelected() {
        return this.propertyButton.getSelection();
    }
}

