/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.debug.core;

import java.util.logging.Level;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.debug.core.AtlDebugElement;
import org.eclipse.m2m.atl.debug.core.AtlDebugTarget;
import org.eclipse.m2m.atl.debug.core.adwp.AtlValue;
import org.eclipse.m2m.atl.debug.core.adwp.ObjectReference;

public class AtlVariable
extends AtlDebugElement
implements IVariable {
    public static final int UNKNOWN = -1;
    public static final int LOCALVARIABLE = 0;
    public static final int REFERENCE = 1;
    public static final int ATTRIBUTE = 2;
    public static final int SUPERTYPE = 3;
    public static final int ELEMENT = 4;
    private String name;
    private String typeName;
    private int description;
    private IValue variableValue;
    private AtlDebugTarget atlDT;
    private int idVariable = -1;

    public AtlVariable(String name, IValue value, AtlDebugTarget atlDT, int description) {
        super(atlDT);
        try {
            this.name = name;
            this.typeName = value.getReferenceTypeName();
            this.description = description;
            this.variableValue = value;
            if (value instanceof AtlValue && ((AtlValue)value).getValue() instanceof ObjectReference) {
                this.idVariable = ((ObjectReference)((AtlValue)value).getValue()).getId();
            }
        }
        catch (DebugException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        this.atlDT = atlDT;
    }

    public IValue getValue() throws DebugException {
        return this.variableValue;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.typeName;
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    @Override
    public IDebugTarget getDebugTarget() {
        return this.atlDT.getDebugTarget();
    }

    @Override
    public ILaunch getLaunch() {
        return this.atlDT.getLaunch();
    }

    public void setValue(String expression) throws DebugException {
    }

    public void setValue(IValue value) throws DebugException {
        this.variableValue = value;
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public int getDescription() {
        return this.description;
    }

    public int getIdVariable() {
        return this.idVariable;
    }
}

