/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.internal.docker.core.ContainerFileProxy;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandMessages;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.jobs.CopyFromDockerJob;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ContainerCopyFrom;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CopyFromContainerCommandHandler
extends AbstractHandler {
    private static final String ERROR_COPYING_FROM_CONTAINER_NO_CONNECTION = "command.copyfromcontainer.failure.no_connection";
    private static final String MISSING_CONNECTION = "missing_connection";

    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        IDockerConnection connection = CommandUtils.getCurrentConnection(activePart);
        List<IDockerContainer> selectedContainers = CommandUtils.getSelectedContainers(activePart);
        if (selectedContainers.size() != 1) {
            return null;
        }
        IDockerContainer container = selectedContainers.get(0);
        if (connection == null) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CommandMessages.getString(MISSING_CONNECTION), (String)CommandMessages.getString(ERROR_COPYING_FROM_CONTAINER_NO_CONNECTION));
        } else {
            ContainerCopyFrom wizard = new ContainerCopyFrom(connection, container);
            boolean copyFromContainer = CommandUtils.openWizard((IWizard)wizard, HandlerUtil.getActiveShell((ExecutionEvent)event));
            if (copyFromContainer) {
                this.performCopyFromContainer(connection, container, wizard.getTarget(), wizard.getSources());
            }
        }
        return null;
    }

    private void performCopyFromContainer(IDockerConnection connection, IDockerContainer container, String target, List<ContainerFileProxy> files) {
        Set<Path> copyset = files.stream().map(x -> new Path(x.getFullPath())).collect(Collectors.toSet());
        CopyFromDockerJob copyFromContainerJob = new CopyFromDockerJob(connection, CopyFromDockerJob.CopyType.Container, container.id(), copyset, new Path(target));
        copyFromContainerJob.schedule();
    }
}

