/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.extensions.contentmodel.model.CMAttributeDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.utils.XMLGenerator;
import org.eclipse.lemminx.extensions.xsi.XSISchemaModel;
import org.eclipse.lemminx.services.extensions.ISharedSettingsRequest;
import org.eclipse.lemminx.services.extensions.hover.HoverParticipantAdapter;
import org.eclipse.lemminx.services.extensions.hover.IHoverRequest;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadingException;
import org.eclipse.lemminx.utils.MarkupContentFactory;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class ContentModelHoverParticipant
extends HoverParticipantAdapter {
    @Override
    public Hover onTag(IHoverRequest hoverRequest, CancelChecker cancelChecker) throws Exception {
        try {
            ContentModelManager contentModelManager = (ContentModelManager)hoverRequest.getComponent(ContentModelManager.class);
            DOMElement element = (DOMElement)hoverRequest.getNode();
            Collection<CMDocument> cmDocuments = contentModelManager.findCMDocument(element);
            if (cmDocuments.isEmpty()) {
                return null;
            }
            ArrayList<MarkupContent> contentValues = new ArrayList<MarkupContent>();
            for (CMDocument cmDocument : cmDocuments) {
                CMElementDeclaration cmElement = cmDocument.findCMElement(element);
                if (cmElement == null) continue;
                MarkupContent content = XMLGenerator.createMarkupContent(cmElement, hoverRequest);
                ContentModelHoverParticipant.fillHoverContent(content, contentValues);
            }
            return MarkupContentFactory.createHover(contentValues);
        }
        catch (CacheResourceDownloadingException e) {
            return ContentModelHoverParticipant.getCacheWarningHover(e, hoverRequest);
        }
    }

    @Override
    public Hover onAttributeName(IHoverRequest hoverRequest, CancelChecker cancelChecker) throws Exception {
        DOMAttr attribute = (DOMAttr)hoverRequest.getNode();
        DOMElement element = attribute.getOwnerElement();
        try {
            ContentModelManager contentModelManager = (ContentModelManager)hoverRequest.getComponent(ContentModelManager.class);
            Collection<CMDocument> cmDocuments = contentModelManager.findCMDocument(element);
            if (cmDocuments.isEmpty()) {
                return null;
            }
            ArrayList<MarkupContent> contentValues = new ArrayList<MarkupContent>();
            for (CMDocument cmDocument : cmDocuments) {
                CMAttributeDeclaration cmAttribute;
                CMElementDeclaration cmElement = cmDocument.findCMElement(element);
                if (cmElement == null || (cmAttribute = cmElement.findCMAttribute(attribute)) == null) continue;
                MarkupContent content = XMLGenerator.createMarkupContent(cmAttribute, cmElement, (ISharedSettingsRequest)hoverRequest);
                ContentModelHoverParticipant.fillHoverContent(content, contentValues);
            }
            return MarkupContentFactory.createHover(contentValues);
        }
        catch (CacheResourceDownloadingException e) {
            return ContentModelHoverParticipant.getCacheWarningHover(e, hoverRequest);
        }
    }

    @Override
    public Hover onAttributeValue(IHoverRequest hoverRequest, CancelChecker cancelChecker) throws Exception {
        DOMAttr attribute = (DOMAttr)hoverRequest.getNode();
        Hover temp = XSISchemaModel.computeHoverResponse(attribute, hoverRequest);
        if (temp != null) {
            return temp;
        }
        DOMElement element = attribute.getOwnerElement();
        try {
            ContentModelManager contentModelManager = (ContentModelManager)hoverRequest.getComponent(ContentModelManager.class);
            Collection<CMDocument> cmDocuments = contentModelManager.findCMDocument(element);
            if (cmDocuments.isEmpty()) {
                return null;
            }
            String attributeValue = attribute.getValue();
            ArrayList<MarkupContent> contentValues = new ArrayList<MarkupContent>();
            for (CMDocument cmDocument : cmDocuments) {
                CMAttributeDeclaration cmAttribute;
                CMElementDeclaration cmElement = cmDocument.findCMElement(element);
                if (cmElement == null || (cmAttribute = cmElement.findCMAttribute(attribute)) == null) continue;
                MarkupContent content = XMLGenerator.createMarkupContent(cmAttribute, attributeValue, cmElement, hoverRequest);
                ContentModelHoverParticipant.fillHoverContent(content, contentValues);
            }
            return MarkupContentFactory.createHover(contentValues);
        }
        catch (CacheResourceDownloadingException e) {
            return ContentModelHoverParticipant.getCacheWarningHover(e, hoverRequest);
        }
    }

    @Override
    public Hover onText(IHoverRequest hoverRequest, CancelChecker cancelChecker) throws Exception {
        DOMText text = (DOMText)hoverRequest.getNode();
        DOMElement element = text.getParentElement();
        if (element == null) {
            return null;
        }
        try {
            ContentModelManager contentModelManager = (ContentModelManager)hoverRequest.getComponent(ContentModelManager.class);
            Collection<CMDocument> cmDocuments = contentModelManager.findCMDocument(element);
            if (cmDocuments.isEmpty()) {
                return null;
            }
            String textContent = text.getTextContent();
            if (textContent != null) {
                textContent = textContent.trim();
            }
            ArrayList<MarkupContent> contentValues = new ArrayList<MarkupContent>();
            for (CMDocument cmDocument : cmDocuments) {
                CMElementDeclaration cmElement = cmDocument.findCMElement(element);
                if (cmElement == null) continue;
                MarkupContent content = XMLGenerator.createMarkupContent(cmElement, textContent, (ISharedSettingsRequest)hoverRequest);
                ContentModelHoverParticipant.fillHoverContent(content, contentValues);
            }
            return MarkupContentFactory.createHover(contentValues);
        }
        catch (CacheResourceDownloadingException e) {
            return ContentModelHoverParticipant.getCacheWarningHover(e, hoverRequest);
        }
    }

    private static Hover getCacheWarningHover(CacheResourceDownloadingException e, ISharedSettingsRequest support) {
        MarkupContent content = MarkupContentFactory.createMarkupContent("Cannot process " + (e.isDTD() ? "DTD" : "XML Schema") + " hover: " + e.getMessage(), "markdown", support);
        return new Hover(content);
    }

    private static void fillHoverContent(MarkupContent content, List<MarkupContent> contents) {
        if (content != null && !StringUtils.isEmpty(content.getValue())) {
            contents.add(content);
        }
    }
}

