/*******************************************************************************
 * Copyright (c) 2000, 2007 IBM Corporation and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 
 *******************************************************************************/

package org.eclipse.dltk.compiler;

/**
 * Exception thrown by a scanner when encountering lexical errors.
 * <p>
 * This class is not intended to be instantiated or subclassed by clients.
 * </p>
 */
public class InvalidInputException extends Exception {

	private static final long serialVersionUID = 2909732853499731592L; // backward
																		// compatible

	/**
	 * Creates a new exception with no detail message.
	 */
	public InvalidInputException() {
		super();
	}

	/**
	 * Creates a new exception with the given detail message.
	 * 
	 * @param message
	 *            the detail message
	 */
	public InvalidInputException(String message) {
		super(message);
	}
}
