/*
 * Copyright (C) 2004-2011
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.sun.tools.rngom.digested;

import com.sun.tools.rngom.parse.Context;

/**
 * @author Kohsuke Kawaguchi (kk@kohsuke.org)
 */
public class DValuePattern extends DPattern {
    private String datatypeLibrary;
    private String type;
    private String value;
    private Context context;
    private String ns;

    public DValuePattern(String datatypeLibrary, String type, String value, Context context, String ns) {
        this.datatypeLibrary = datatypeLibrary;
        this.type = type;
        this.value = value;
        this.context = context;
        this.ns = ns;
    }

    public String getDatatypeLibrary() {
        return datatypeLibrary;
    }

    public String getType() {
        return type;
    }

    public String getValue() {
        return value;
    }

    public Context getContext() {
        return context;
    }

    public String getNs() {
        return ns;
    }

    public boolean isNullable() {
        return false;
    }

    public Object accept( DPatternVisitor visitor ) {
        return visitor.onValue(this);
    }
}
