/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.language.keywords;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.language.keywords.IPHPKeywordsInitializer;
import org.eclipse.php.internal.core.language.keywords.KeywordInitializerPHP_5;
import org.eclipse.php.internal.core.language.keywords.KeywordInitializerPHP_5_3;
import org.eclipse.php.internal.core.language.keywords.KeywordInitializerPHP_5_4;
import org.eclipse.php.internal.core.language.keywords.KeywordInitializerPHP_5_5;
import org.eclipse.php.internal.core.language.keywords.KeywordInitializerPHP_5_6;
import org.eclipse.php.internal.core.language.keywords.KeywordInitializerPHP_7;
import org.eclipse.php.internal.core.language.keywords.KeywordInitializerPHP_7_1;
import org.eclipse.php.internal.core.language.keywords.KeywordInitializerPHP_7_2;
import org.eclipse.php.internal.core.language.keywords.KeywordInitializerPHP_7_3;
import org.eclipse.php.internal.core.language.keywords.KeywordInitializerPHP_7_4;
import org.eclipse.php.internal.core.language.keywords.KeywordInitializerPHP_8_0;
import org.eclipse.php.internal.core.language.keywords.KeywordInitializerPHP_8_1;
import org.eclipse.php.internal.core.language.keywords.KeywordInitializerPHP_8_2;
import org.eclipse.php.internal.core.language.keywords.KeywordInitializerPHP_8_3;
import org.eclipse.php.internal.core.search.Messages;

public class PHPKeywords {
    public static final int CLASS_BODY = 1;
    public static final int METHOD_BODY = 2;
    public static final int GLOBAL = 4;
    public static final int METHOD_PARAM = 8;
    private static final Map<PHPVersion, PHPKeywords> instances = new HashMap<PHPVersion, PHPKeywords>();
    private Collection<KeywordData> keywordData = new TreeSet<KeywordData>();
    private Collection<String> keywordNames = new TreeSet<String>();

    private PHPKeywords(IPHPKeywordsInitializer keywordsInitializer) {
        keywordsInitializer.initialize(this.keywordData);
        keywordsInitializer.initializeSpecific(this.keywordData);
        for (KeywordData kd : this.keywordData) {
            this.keywordNames.add(kd.name);
        }
    }

    public static PHPKeywords getInstance(IProject project) {
        return PHPKeywords.getInstance(ProjectOptions.getPHPVersion(project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PHPKeywords getInstance(PHPVersion version) {
        Map<PHPVersion, PHPKeywords> map = instances;
        synchronized (map) {
            if (!instances.containsKey((Object)version)) {
                PHPKeywords instance;
                if (PHPVersion.PHP5 == version) {
                    instance = new PHPKeywords(new KeywordInitializerPHP_5());
                } else if (PHPVersion.PHP5_3 == version) {
                    instance = new PHPKeywords(new KeywordInitializerPHP_5_3());
                } else if (PHPVersion.PHP5_4 == version) {
                    instance = new PHPKeywords(new KeywordInitializerPHP_5_4());
                } else if (PHPVersion.PHP5_5 == version) {
                    instance = new PHPKeywords(new KeywordInitializerPHP_5_5());
                } else if (PHPVersion.PHP5_6 == version) {
                    instance = new PHPKeywords(new KeywordInitializerPHP_5_6());
                } else if (PHPVersion.PHP7_0 == version) {
                    instance = new PHPKeywords(new KeywordInitializerPHP_7());
                } else if (PHPVersion.PHP7_1 == version) {
                    instance = new PHPKeywords(new KeywordInitializerPHP_7_1());
                } else if (PHPVersion.PHP7_2 == version) {
                    instance = new PHPKeywords(new KeywordInitializerPHP_7_2());
                } else if (PHPVersion.PHP7_3 == version) {
                    instance = new PHPKeywords(new KeywordInitializerPHP_7_3());
                } else if (PHPVersion.PHP7_4 == version) {
                    instance = new PHPKeywords(new KeywordInitializerPHP_7_4());
                } else if (PHPVersion.PHP8_0 == version) {
                    instance = new PHPKeywords(new KeywordInitializerPHP_8_0());
                } else if (PHPVersion.PHP8_1 == version) {
                    instance = new PHPKeywords(new KeywordInitializerPHP_8_1());
                } else if (PHPVersion.PHP8_2 == version) {
                    instance = new PHPKeywords(new KeywordInitializerPHP_8_2());
                } else if (PHPVersion.PHP8_3 == version) {
                    instance = new PHPKeywords(new KeywordInitializerPHP_8_3());
                } else {
                    if (version == null) {
                        throw new IllegalArgumentException(CoreMessages.getString("UnknownPHPVersion_0"));
                    }
                    throw new IllegalArgumentException(Messages.format(CoreMessages.getString("UnknownPHPVersion_1"), (Object)version));
                }
                instances.put(version, instance);
            }
        }
        return instances.get((Object)version);
    }

    public Collection<String> getKeywordNames() {
        return this.keywordNames;
    }

    public Collection<KeywordData> findByPrefix(String prefix) {
        LinkedList<KeywordData> result = new LinkedList<KeywordData>();
        if (prefix == null) {
            return result;
        }
        for (KeywordData data : this.keywordData) {
            if (!data.name.startsWith(prefix) && (!data.ignoreCase || !StringUtils.startsWithIgnoreCase((CharSequence)data.name, (CharSequence)prefix))) continue;
            result.add(data);
        }
        return result;
    }

    public Collection<String> findNamesByPrefix(String prefix) {
        LinkedList<String> result = new LinkedList<String>();
        if (prefix == null) {
            return result;
        }
        for (KeywordData data : this.keywordData) {
            if (!data.name.startsWith(prefix) && (!data.ignoreCase || !StringUtils.startsWithIgnoreCase((CharSequence)data.name, (CharSequence)prefix))) continue;
            result.add(data.name);
        }
        return result;
    }

    public static class KeywordData
    implements Comparable<KeywordData> {
        public String name;
        public String suffix;
        public int suffixOffset;
        public int context = 6;
        public boolean ignoreCase = false;

        public KeywordData(String name, String suffix, int suffixOffset, boolean ignoreCase) {
            this.name = name;
            this.suffix = suffix;
            this.suffixOffset = suffixOffset;
            this.ignoreCase = ignoreCase;
        }

        public KeywordData(String name, String suffix, int suffixOffset) {
            this(name, suffix, suffixOffset, false);
        }

        public KeywordData(String name, String suffix, int suffixOffset, int context, boolean ignoreCase) {
            this.name = name;
            this.suffix = suffix;
            this.suffixOffset = suffixOffset;
            this.context = context;
            this.ignoreCase = ignoreCase;
        }

        public KeywordData(String name, String suffix, int suffixOffset, int context) {
            this(name, suffix, suffixOffset, context, false);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeywordData other = (KeywordData)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        @Override
        public int compareTo(KeywordData o) {
            return this.ignoreCase ? this.name.compareToIgnoreCase(o.name) : this.name.compareTo(o.name);
        }
    }
}

