/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.visitor.Visitor;

public class InfixExpression
extends Expression {
    public static final int OP_IS_IDENTICAL = 0;
    public static final int OP_IS_NOT_IDENTICAL = 1;
    public static final int OP_IS_EQUAL = 2;
    public static final int OP_IS_NOT_EQUAL = 3;
    public static final int OP_RGREATER = 4;
    public static final int OP_IS_SMALLER_OR_EQUAL = 5;
    public static final int OP_LGREATER = 6;
    public static final int OP_IS_GREATER_OR_EQUAL = 7;
    public static final int OP_BOOL_OR = 8;
    public static final int OP_BOOL_AND = 9;
    public static final int OP_STRING_OR = 10;
    public static final int OP_STRING_AND = 11;
    public static final int OP_STRING_XOR = 12;
    public static final int OP_OR = 13;
    public static final int OP_AND = 14;
    public static final int OP_XOR = 15;
    public static final int OP_CONCAT = 16;
    public static final int OP_PLUS = 17;
    public static final int OP_MINUS = 18;
    public static final int OP_MUL = 19;
    public static final int OP_DIV = 20;
    public static final int OP_MOD = 21;
    public static final int OP_SL = 22;
    public static final int OP_SR = 23;
    public static final int OP_POW = 24;
    public static final int OP_SPACESHIP = 25;
    private Expression left;
    private int operator;
    private Expression right;
    public static final ChildPropertyDescriptor LEFT_OPERAND_PROPERTY = new ChildPropertyDescriptor(InfixExpression.class, "left", Expression.class, true, true);
    public static final SimplePropertyDescriptor OPERATOR_PROPERTY = new SimplePropertyDescriptor(InfixExpression.class, "operator", Integer.class, true);
    public static final ChildPropertyDescriptor RIGHT_OPERAND_PROPERTY = new ChildPropertyDescriptor(InfixExpression.class, "right", Expression.class, true, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> properyList = new ArrayList<StructuralPropertyDescriptor>(3);
        properyList.add(LEFT_OPERAND_PROPERTY);
        properyList.add(OPERATOR_PROPERTY);
        properyList.add(RIGHT_OPERAND_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    public InfixExpression(int start, int end, AST ast, Expression left, int operator, Expression right) {
        super(start, end, ast);
        if (right == null || left == null || InfixExpression.getOperator(operator) == null) {
            throw new IllegalArgumentException();
        }
        this.setLeft(left);
        this.setOperator(operator);
        this.setRight(right);
    }

    public InfixExpression(AST ast) {
        super(ast);
    }

    public static String getOperator(int operator) {
        switch (operator) {
            case 0: {
                return "===";
            }
            case 1: {
                return "!==";
            }
            case 2: {
                return "==";
            }
            case 3: {
                return "!=";
            }
            case 4: {
                return "<";
            }
            case 5: {
                return "<=";
            }
            case 6: {
                return ">";
            }
            case 7: {
                return ">=";
            }
            case 8: {
                return "||";
            }
            case 9: {
                return "&&";
            }
            case 10: {
                return "or";
            }
            case 11: {
                return "and";
            }
            case 12: {
                return "xor";
            }
            case 13: {
                return "|";
            }
            case 14: {
                return "&";
            }
            case 15: {
                return "^";
            }
            case 16: {
                return ".";
            }
            case 17: {
                return "+";
            }
            case 18: {
                return "-";
            }
            case 19: {
                return "*";
            }
            case 20: {
                return "/";
            }
            case 21: {
                return "%";
            }
            case 22: {
                return "<<";
            }
            case 23: {
                return ">>";
            }
            case 24: {
                return "**";
            }
            case 25: {
                return "<=>";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.left.accept(visitor);
        this.right.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.left.traverseTopDown(visitor);
        this.right.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.left.traverseBottomUp(visitor);
        this.right.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuilder buffer, String tab) {
        buffer.append(tab).append("<InfixExpression");
        this.appendInterval(buffer);
        buffer.append(" operator='").append(InfixExpression.getXmlStringValue(InfixExpression.getOperator(this.operator))).append("'>\n");
        this.left.toString(buffer, "\t" + tab);
        buffer.append("\n");
        this.right.toString(buffer, "\t" + tab);
        buffer.append("\n").append(tab).append("</InfixExpression>");
    }

    @Override
    public int getType() {
        return 37;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setOperator(int operator) {
        if (InfixExpression.getOperator(operator) == null) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(OPERATOR_PROPERTY);
        this.operator = operator;
        this.postValueChange(OPERATOR_PROPERTY);
    }

    public Expression getLeft() {
        return this.left;
    }

    public void setLeft(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.left;
        this.preReplaceChild(oldChild, expression, LEFT_OPERAND_PROPERTY);
        this.left = expression;
        this.postReplaceChild(oldChild, expression, LEFT_OPERAND_PROPERTY);
    }

    public Expression getRight() {
        return this.right;
    }

    public void setRight(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.right;
        this.preReplaceChild(oldChild, expression, RIGHT_OPERAND_PROPERTY);
        this.right = expression;
        this.postReplaceChild(oldChild, expression, RIGHT_OPERAND_PROPERTY);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression left = ASTNode.copySubtree(target, this.getLeft());
        Expression right = ASTNode.copySubtree(target, this.getRight());
        InfixExpression result = new InfixExpression(this.getStart(), this.getEnd(), target, left, this.getOperator(), right);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == LEFT_OPERAND_PROPERTY) {
            if (get) {
                return this.getLeft();
            }
            this.setLeft((Expression)child);
            return null;
        }
        if (property == RIGHT_OPERAND_PROPERTY) {
            if (get) {
                return this.getRight();
            }
            this.setRight((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == OPERATOR_PROPERTY) {
            if (get) {
                return this.getOperator();
            }
            this.setOperator(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }
}

