/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.wizards;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.phpunit.PHPUnitMessages;
import org.eclipse.php.phpunit.PHPUnitPlugin;
import org.eclipse.php.phpunit.ui.wizards.PHPUnitWizard;
import org.eclipse.php.phpunit.ui.wizards.TestCaseWizardPage;
import org.eclipse.php.phpunit.ui.wizards.templates.TestCaseClassTemplate;
import org.eclipse.php.phpunit.ui.wizards.templates.TestCaseFunctionTemplate;

public class TestCaseWizard
extends PHPUnitWizard {
    public TestCaseWizard() {
        this.setWindowTitle(PHPUnitMessages.TestCaseWizard_0);
        this.setDefaultPageImageDescriptor(PHPUnitPlugin.getImageDescriptor("wizban/newtest_wiz.png"));
    }

    public void addPages() {
        this.page = new TestCaseWizardPage();
        this.addPage((IWizardPage)this.page);
        this.page.init(this.getSelection());
    }

    String generateClassFile() {
        TestCaseClassTemplate template = new TestCaseClassTemplate();
        try {
            TestCaseWizardPage page = (TestCaseWizardPage)this.page;
            template.resolveTemplate();
            IType masterClass = (IType)page.getElementToTest();
            IProject project = page.getTestContainer().getProject();
            template.setMasterElement((IModelElement)masterClass, page.getElementToTestName(), project);
            template.setTestClassParams(page.getClassName(), page.getTestContainer().getLocation().append(page.getFileName()).toOSString());
            template.setTestSuperClass(page.getSuperClass(), page.getSuperClassName(), project);
            if (masterClass != null) {
                IMethod[] functions = masterClass.getMethods();
                int i = 0;
                while (i < functions.length) {
                    int modifiers = functions[i].getFlags();
                    if (!(PHPFlags.isAbstract((int)modifiers) || PHPFlags.isPrivate((int)modifiers) || PHPFlags.isProtected((int)modifiers))) {
                        template.addMethod(functions[i].getElementName(), (modifiers & 0x80) > 0);
                    }
                    ++i;
                }
            }
            template.compileMethods();
            return template.compileTemplate();
        }
        catch (IOException | ModelException e) {
            PHPUnitPlugin.log(e);
            return "";
        }
    }

    @Override
    String generateFile() {
        if (((TestCaseWizardPage)this.page).getElementToTest() instanceof IMethod) {
            return this.generateFunctionFile();
        }
        return this.generateClassFile();
    }

    private String generateFunctionFile() {
        TestCaseFunctionTemplate template = new TestCaseFunctionTemplate();
        try {
            TestCaseWizardPage page = (TestCaseWizardPage)this.page;
            template.resolveTemplate();
            template.setTestClassParams(page.getClassName(), page.getTestContainer().getLocation().append(page.getFileName()).toOSString());
            IProject project = page.getTestContainer().getProject();
            template.setTestSuperClass(page.getSuperClass(), page.getSuperClassName(), project);
            template.setMasterElement(page.getElementToTest(), page.getElementToTestName(), project);
            return template.compileTemplate();
        }
        catch (IOException e) {
            PHPUnitPlugin.log(e);
            return "";
        }
    }
}

