/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util.generic;

import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.JavaInfoAddProperties;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;

public abstract class CopyPropertyTopAbstractSupport {
    protected final void install(JavaInfo javaInfo, String prefix) {
        for (String parameter : javaInfo.getDescription().getParameters().keySet()) {
            String[] parts;
            String sourcePath = null;
            String copyTitle = null;
            PropertyCategory category = PropertyCategory.NORMAL;
            if (!parameter.startsWith(prefix)) continue;
            String[] stringArray = parts = StringUtils.split((String)parameter);
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (part.startsWith("from=")) {
                    sourcePath = StringUtils.removeStart((String)part, (String)"from=");
                }
                if (part.startsWith("to=")) {
                    copyTitle = StringUtils.removeStart((String)part, (String)"to=");
                }
                if (part.startsWith("category=")) {
                    String categoryText = StringUtils.removeStart((String)part, (String)"category=");
                    category = PropertyCategory.get((String)categoryText, (PropertyCategory)category);
                }
                ++n2;
            }
            if (sourcePath == null || copyTitle == null) {
                String message = "No 'from' or 'to' attributes: " + parameter;
                JavaInfoUtils.getState(javaInfo).addWarning(new EditorWarning(message, null));
                continue;
            }
            Predicate<JavaInfo> targetPredicate = this.createTargetPredicate(javaInfo);
            new CopyProcessor(javaInfo, targetPredicate, sourcePath, copyTitle, category);
        }
    }

    protected abstract Predicate<JavaInfo> createTargetPredicate(JavaInfo var1);

    static class CopyProcessor {
        private final Predicate<JavaInfo> m_targetPredicate;
        private final String m_sourcePath;
        private final String m_copyTitle;
        private final PropertyCategory m_category;
        private Property m_oldSource;
        private Property m_oldCopy;

        CopyProcessor(JavaInfo someJavaInfo, Predicate<JavaInfo> targetPredicate, String sourcePath, String copyTitle, PropertyCategory category) {
            this.m_targetPredicate = targetPredicate;
            this.m_sourcePath = sourcePath;
            this.m_copyTitle = copyTitle;
            this.m_category = category;
            someJavaInfo.addBroadcastListener(new JavaInfoAddProperties(){

                @Override
                public void invoke(JavaInfo javaInfo, List<Property> properties) throws Exception {
                    Property source;
                    Property copy;
                    if (m_targetPredicate.test(javaInfo) && (copy = this.getCopy(source = PropertyUtils.getByPath(properties, (String)m_sourcePath))) != null) {
                        properties.add(copy);
                    }
                }
            });
        }

        private Property getCopy(Property source) {
            if (this.m_oldSource != source) {
                this.m_oldSource = source;
                this.m_oldCopy = this.createCopy(source);
            }
            return this.m_oldCopy;
        }

        /*
         * WARNING - void declaration
         */
        private Property createCopy(Property source) {
            Property property = source;
            if (property instanceof GenericPropertyImpl) {
                void genericProperty;
                GenericPropertyImpl genericPropertyImpl = (GenericPropertyImpl)property;
                GenericPropertyImpl cfr_ignored_0 = (GenericPropertyImpl)property;
                GenericPropertyImpl copy = new GenericPropertyImpl((GenericPropertyImpl)genericProperty, this.m_copyTitle);
                copy.setCategory(this.m_category);
                return copy;
            }
            return null;
        }
    }
}

