/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.ui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.SOEUIPlugin;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.ui.Messages;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.ui.ResourceAndContainerGroup;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.ILogger;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.Images;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class SaveAsDialog
extends TitleAreaDialog {
    private static ILogger _log = SOEUIPlugin.getLogger(null);
    private IFile _originalFile = null;
    private String _originalName = null;
    private IPath _result;
    private ResourceAndContainerGroup _resourceGroup;
    private Button _okButton;
    private String _content;
    private static final String ENCODING = "UTF-8";
    private Image _dlgTitleImage = null;
    private boolean _first = true;
    private Listener _listener = new Listener(){

        public void handleEvent(Event event) {
            if (SaveAsDialog.this._resourceGroup != null) {
                boolean valid = SaveAsDialog.this._resourceGroup.validateContainer();
                if (!valid) {
                    SaveAsDialog.this.getButton(0).setEnabled(false);
                } else {
                    SaveAsDialog.this.setMessage(null);
                    SaveAsDialog.this.getButton(0).setEnabled(true);
                }
            }
        }
    };

    public SaveAsDialog(Shell parentShell, String content) {
        super(parentShell);
        this._content = content;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.SaveAsDialog_title);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.initializeControls();
        this.validatePage();
        this._resourceGroup.setFocus();
        this.setTitle(Messages.SaveAsDialog_title);
        this.setMessage(Messages.SaveAsDialog_message);
        this._dlgTitleImage = Images.get("org.eclipse.datatools.sqltools.schemaobjecteditor.pagessaveas_wiz.png");
        this.setTitleImage(this._dlgTitleImage);
        this._first = false;
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this._okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parentComposite.getFont());
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                SaveAsDialog.this.setDialogComplete(SaveAsDialog.this.validatePage());
            }
        };
        this._resourceGroup = new ResourceAndContainerGroup(composite, listener, "", "file", this._listener);
        this._resourceGroup.setAllowExistingResources(true);
        return parentComposite;
    }

    public IPath getResult() {
        return this._result;
    }

    private void initializeControls() {
        if (this._originalFile != null) {
            this._resourceGroup.setContainerFullPath(this._originalFile.getParent().getFullPath());
            this._resourceGroup.setResource(this._originalFile.getName());
        } else if (this._originalName != null) {
            this._resourceGroup.setResource(this._originalName);
        }
        this.setDialogComplete(this.validatePage());
    }

    protected void okPressed() {
        block12: {
            String filename = this._resourceGroup.getResource();
            IPath path = this._resourceGroup.getContainerFullPath().append(filename);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            if (file.exists()) {
                String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                String question = NLS.bind((String)Messages.SaveAsDialog_overwrite, (Object[])new Object[]{path.toOSString()});
                MessageDialog d = new MessageDialog(this.getShell(), Messages.SaveAsDialog_question, null, question, 3, buttons, 0);
                int overwrite = d.open();
                switch (overwrite) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return;
                    }
                    default: {
                        this.cancelPressed();
                        return;
                    }
                }
            }
            this._result = path;
            try {
                String resource = this._resourceGroup.getContainerFullPath().toString();
                if (ResourcesPlugin.getWorkspace().getRoot().findMember(resource) == null) break block12;
                String fullpath = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().findMember(resource).getLocation().toOSString()) + File.separator + filename;
                PrintWriter output = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fullpath), ENCODING));
                if (this._content != null) {
                    output.write(this._content);
                }
                if (output != null) {
                    output.close();
                }
                try {
                    if (file != null && file.getProject() != null) {
                        file.getProject().refreshLocal(2, null);
                        file.setCharset(ENCODING, (IProgressMonitor)new NullProgressMonitor());
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                }
                catch (CoreException e) {
                    _log.error("SaveAsDialog_open_error", (Throwable)e);
                }
            }
            catch (IOException ex) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.SaveAsDialog_error, (String)Messages.SaveAsDialog_error_msg, (IStatus)new Status(4, "org.eclipse.datatools.sqltools.schemaobjecteditor.ui", 0, ex.getMessage(), (Throwable)ex));
            }
        }
        this.close();
    }

    protected void setDialogComplete(boolean value) {
        this._okButton.setEnabled(value);
    }

    public void setOriginalFile(IFile originalFile) {
        this._originalFile = originalFile;
    }

    public void setOriginalName(String originalName) {
        this._originalName = originalName;
    }

    private boolean validatePage() {
        this.setErrorMessage(null);
        this.setMessage(Messages.SaveAsDialog_message);
        if (!this._resourceGroup.areAllValuesValid()) {
            if (this._resourceGroup.getProblemType() == 1 || this._resourceGroup.getProblemType() == 5) {
                if (this._first) {
                    this.setMessage(this._resourceGroup.getProblemMessage());
                    this.setErrorMessage(null);
                } else {
                    this.setErrorMessage(this._resourceGroup.getProblemMessage());
                }
            } else {
                this.setErrorMessage(this._resourceGroup.getProblemMessage());
            }
            return false;
        }
        return true;
    }
}

