/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.phpIni;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class INIFileModifier {
    private static final String GLOBAL_SECTION = "__global__";
    private static final Pattern SECTION_PATTERN = Pattern.compile("\\[([^\\]]+)\\]");
    private static final Pattern NAME_VAL_PATTERN = Pattern.compile("([\\w]+)\\p{javaWhitespace}*=\\p{javaWhitespace}*(.*)");
    private File configFile;
    private List<INIFileSection> sections;

    public INIFileModifier(String configFile) throws IOException {
        this(new File(configFile));
    }

    public INIFileModifier(File configFile) throws IOException {
        this.configFile = configFile;
        this.sections = new LinkedList<INIFileSection>();
        this.read();
    }

    public void addEntry(String name, String value, boolean replace) {
        this.addEntry(GLOBAL_SECTION, name, value, replace, null);
    }

    public void addEntry(String name, String value) {
        this.addEntry(GLOBAL_SECTION, name, value, false, null);
    }

    public void addEntry(String sectionName, String name, String value) {
        this.addEntry(sectionName, name, value, false, null);
    }

    public void addEntry(String sectionName, String name, String value, boolean replace, String replacePattern) {
        if (sectionName == null || name == null || value == null) {
            throw new NullPointerException();
        }
        for (INIFileSection section : this.sections) {
            if (!section.name.equals(sectionName)) continue;
            if (replace) {
                int i = 0;
                while (i < section.lines.size()) {
                    Matcher m = NAME_VAL_PATTERN.matcher(section.lines.get(i));
                    if (m.matches()) {
                        String oldName = m.group(1);
                        String oldValue = m.group(2);
                        if (oldName.equals(name) && (replacePattern == null || oldValue.matches(replacePattern))) {
                            section.lines.set(i, String.valueOf(name) + '=' + this.quoteString(value));
                        }
                    }
                    ++i;
                }
                break;
            }
            section.lines.add(String.valueOf(name) + '=' + this.quoteString(value));
            break;
        }
    }

    public boolean removeEntry(String name, String removePattern) {
        return this.removeEntry(GLOBAL_SECTION, name, removePattern);
    }

    public boolean removeAllEntries(String name) {
        return this.removeEntry(null, name, null);
    }

    public boolean removeAllEntries(String name, String removePattern) {
        return this.removeEntry(null, name, removePattern);
    }

    public boolean removeEntry(String sectionName, String name, String removePattern) {
        if (name == null) {
            throw new NullPointerException();
        }
        boolean removed = false;
        for (INIFileSection section : this.sections) {
            if (sectionName != null && !section.name.equals(sectionName)) continue;
            int i = 0;
            while (i < section.lines.size()) {
                Matcher m = NAME_VAL_PATTERN.matcher(section.lines.get(i));
                if (m.matches()) {
                    String oldName = m.group(1);
                    String oldValue = m.group(2);
                    if (oldName.equals(name) && (removePattern == null || oldValue.matches(removePattern))) {
                        section.lines.remove(i--);
                        removed = true;
                    }
                }
                ++i;
            }
            if (sectionName != null) break;
        }
        return removed;
    }

    public void commentEntry(String name, String commentPattern) {
        this.commentEntry(GLOBAL_SECTION, name, commentPattern);
    }

    public void commentAllEntries(String name, String commentPattern) {
        this.commentEntry(null, name, commentPattern);
    }

    public void commentEntry(String sectionName, String name, String commentPattern) {
        if (name == null) {
            throw new NullPointerException();
        }
        for (INIFileSection section : this.sections) {
            if (sectionName != null && !section.name.equals(sectionName)) continue;
            int i = 0;
            while (i < section.lines.size()) {
                String line = section.lines.get(i);
                Matcher m = NAME_VAL_PATTERN.matcher(line);
                if (m.matches()) {
                    String oldName = m.group(1);
                    String oldValue = m.group(2);
                    if (!line.startsWith(";") && oldName.equals(name) && (commentPattern == null || oldValue.matches(commentPattern))) {
                        section.lines.set(i, String.valueOf(';') + line);
                    }
                }
                ++i;
            }
            if (sectionName != null) break;
        }
    }

    public boolean hasEntry(String name) {
        for (INIFileSection section : this.sections) {
            if (!this.hasEntry(section, name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasEntry(String sectionName, String name) {
        for (INIFileSection section : this.sections) {
            if (!section.name.equals(sectionName) || !this.hasEntry(section, name)) continue;
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        this.flush();
    }

    protected void read() throws IOException {
        String line;
        BufferedReader r = new BufferedReader(new FileReader(this.configFile));
        INIFileSection currentSection = new INIFileSection(GLOBAL_SECTION);
        this.sections.add(currentSection);
        while ((line = r.readLine()) != null) {
            Matcher m = SECTION_PATTERN.matcher(line = line.trim());
            if (m.matches()) {
                String sectionName = m.group(1);
                currentSection = new INIFileSection(sectionName);
                this.sections.add(currentSection);
                continue;
            }
            currentSection.lines.add(line);
        }
        r.close();
    }

    protected void flush() throws IOException {
        PrintWriter w = new PrintWriter(new FileWriter(this.configFile));
        for (INIFileSection section : this.sections) {
            if (section.name != GLOBAL_SECTION) {
                w.println(String.valueOf('[') + section.name + ']');
            }
            for (String line : section.lines) {
                w.println(line);
            }
        }
        w.close();
    }

    private String quoteString(String str) {
        if (str.startsWith("\"") && str.endsWith("\"") || str.startsWith("'") && str.endsWith("'")) {
            return str;
        }
        return String.valueOf('\"') + str + '\"';
    }

    private boolean hasEntry(INIFileSection section, String name) {
        int i = 0;
        while (i < section.lines.size()) {
            String entryName;
            Matcher m = NAME_VAL_PATTERN.matcher(section.lines.get(i));
            if (m.matches() && (entryName = m.group(1)).equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    class INIFileSection {
        String name;
        List<String> lines;

        public INIFileSection(String name) {
            this.name = name;
            this.lines = new LinkedList<String>();
        }
    }
}

