/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.model;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.internal.debug.core.zend.debugger.Breakpoint;

public class PHPConditionalBreakpoint
extends PHPLineBreakpoint {
    private boolean fConditionEnabled = false;
    private String fCondition = "";

    public PHPConditionalBreakpoint() {
    }

    public PHPConditionalBreakpoint(final IResource resource, final int lineNumber, final int charStart, final int charEnd, final Map<String, Comparable<?>> attributes) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker("org.eclipse.php.debug.core.PHPConditionalBreakpointMarker");
                attributes.put("org.eclipse.debug.core.enabled", Boolean.TRUE);
                attributes.put("org.eclipse.debug.core.id", PHPConditionalBreakpoint.this.getModelIdentifier());
                attributes.put("message", MessageFormat.format(PHPDebugCoreMessages.LineBreakPointMessage_1, resource.getName(), Integer.toString(lineNumber)));
                attributes.put("org.eclipse.php.debug.core.ConditionEnabled", Boolean.FALSE);
                attributes.put("org.eclipse.php.debug.core.Condition", "");
                attributes.put("org.eclipse.debug.core.persisted", Boolean.FALSE);
                attributes.put("lineNumber", lineNumber);
                attributes.put("charStart", charStart);
                attributes.put("charEnd", charEnd);
                marker.setAttributes(attributes);
                PHPConditionalBreakpoint.this.setMarker(marker);
                PHPConditionalBreakpoint.this.setEnabled(true);
                PHPConditionalBreakpoint.this.register(true);
                PHPConditionalBreakpoint.this.setPersisted(true);
            }
        };
        resource.getWorkspace().run(runnable, null, 1, null);
    }

    @Override
    public void setMarker(IMarker marker) throws CoreException {
        super.setMarker(marker);
        this.fCondition = (String)marker.getAttribute("org.eclipse.php.debug.core.Condition");
        Boolean enabled = (Boolean)marker.getAttribute("org.eclipse.php.debug.core.ConditionEnabled");
        this.fConditionEnabled = enabled != null ? enabled : false;
        this.addConditionToBP();
    }

    public void setConditionWithEnable(boolean enabled, String condition) throws CoreException {
        this.fCondition = condition;
        IMarker marker = this.getMarker();
        marker.setAttribute("org.eclipse.php.debug.core.Condition", (Object)condition);
        this.fConditionEnabled = enabled;
        marker.setAttribute("org.eclipse.php.debug.core.ConditionEnabled", enabled);
        int lineNumber = (Integer)marker.getAttribute("lineNumber");
        if (enabled) {
            String message = NLS.bind((String)PHPDebugCoreMessages.ConditionalBreakPointMessage_1, (Object[])new String[]{marker.getResource().getName(), Integer.toString(lineNumber)});
            message = String.valueOf(message) + NLS.bind((String)PHPDebugCoreMessages.ConditionalBreakPointMessage_2, (Object[])new String[]{condition});
            marker.setAttribute("message", (Object)message);
        } else {
            marker.setAttribute("message", (Object)NLS.bind((String)PHPDebugCoreMessages.LineBreakPointMessage_1, (Object[])new String[]{marker.getResource().getName(), Integer.toString(lineNumber)}));
        }
        this.addConditionToBP();
        this.setConditionChanged(true);
    }

    public String getCondition() {
        return this.fCondition;
    }

    public boolean isConditionEnabled() {
        return this.fConditionEnabled;
    }

    protected void addConditionToBP() {
        Breakpoint rbp = this.getRuntimeBreakpoint();
        if (this.isConditionEnabled()) {
            rbp.setConditionalFlag(true);
            rbp.setExpression(this.getCondition());
        } else {
            rbp.setConditionalFlag(false);
            rbp.setStaticFlag(true);
        }
    }
}

