/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.js.runtime;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.wst.jsdt.chromium.debug.js.Messages;
import org.eclipse.wst.jsdt.chromium.debug.js.util.LaunchConfigurationUtil;
import org.eclipse.wst.jsdt.core.runtime.IJSRunner;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeInstall;
import org.eclipse.wst.jsdt.core.runtime.JSRunnerConfiguration;

public class ChromiumRunner
implements IJSRunner {
    private static final String CONSOLE_ENCODING = "org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING";
    private static final String CHARSET_UTF_8 = "UTF-8";
    private IJSRuntimeInstall jsRuntimeInstall;

    public ChromiumRunner(IJSRuntimeInstall jsRuntimeInstall) {
        this.jsRuntimeInstall = jsRuntimeInstall;
    }

    public IProcess run(JSRunnerConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String[] appArguments;
        int n;
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(this.jsRuntimeInstall.getInstallLocation().getPath());
        String[] chromeRuntimeArguments = this.combineRuntimeArgs(configuration, this.jsRuntimeInstall);
        if (chromeRuntimeArguments.length != 0) {
            String[] stringArray = chromeRuntimeArguments;
            n = chromeRuntimeArguments.length;
            int n2 = 0;
            while (n2 < n) {
                String argument = stringArray[n2];
                cmdLine.add(argument);
                ++n2;
            }
        }
        if ((appArguments = configuration.getProgramArguments()).length != 0) {
            String[] stringArray = appArguments;
            int n3 = appArguments.length;
            n = 0;
            while (n < n3) {
                String argument = stringArray[n];
                cmdLine.add(argument);
                ++n;
            }
        }
        String[] cmds = new String[]{};
        cmds = cmdLine.toArray(cmds);
        ProcessBuilder builder = new ProcessBuilder(cmds);
        try {
            Process process = builder.start();
            builder.redirectErrorStream(true);
            launch.setAttribute(CONSOLE_ENCODING, CHARSET_UTF_8);
            return DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)cmds[0], LaunchConfigurationUtil.getDefaultAttributes());
        }
        catch (Exception ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.chromium.debug.js", Messages.LAUNCH_CONFIGURATION_FAILED_EXECUTION_ERROR, (Throwable)ex));
        }
    }

    protected String[] combineRuntimeArgs(JSRunnerConfiguration configuration, IJSRuntimeInstall jsRuntimeInstall2) {
        String[] launchVMArgs = configuration.getJSRuntimeArguments();
        String[] vmVMArgs = jsRuntimeInstall2.getJSRuntimeArguments();
        if (vmVMArgs == null || vmVMArgs.length == 0) {
            return launchVMArgs;
        }
        String[] allVMArgs = new String[launchVMArgs.length + vmVMArgs.length];
        System.arraycopy(vmVMArgs, 0, allVMArgs, 0, vmVMArgs.length);
        System.arraycopy(launchVMArgs, 0, allVMArgs, vmVMArgs.length, launchVMArgs.length);
        return allVMArgs;
    }
}

