/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.editing;

import java.util.List;
import org.apache.maven.model.Dependency;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.editing.ChangeCreator;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class PomHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PomHelper.class);

    public static Element findDependency(Document document, Dependency dependency) {
        Element dependenciesElement = PomEdits.findChild(document.getDocumentElement(), "dependencies");
        return PomEdits.findChild(dependenciesElement, "dependency", PomEdits.childEquals("groupId", dependency.getGroupId()), PomEdits.childEquals("artifactId", dependency.getArtifactId()));
    }

    private static boolean isOpened(IDocument document) {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IDocument doc;
                    IEditorReference ref = iEditorReferenceArray[n6];
                    IEditorPart editor = ref.getEditor(false);
                    if (editor != null && (doc = (IDocument)editor.getAdapter(IDocument.class)) != null && doc.equals(document)) {
                        return true;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public static TextChange createChange(IFile file, PomEdits.Operation operation, String label, boolean forceSave) throws CoreException {
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getModelForRead(file);
            IStructuredDocument document = model.getStructuredDocument();
            boolean existing = PomHelper.isOpened((IDocument)document);
            IStructuredModel tempModel = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor("org.eclipse.m2e.core.pomFile");
            tempModel.getStructuredDocument().setText((Object)StructuredModelManager.getModelManager(), document.get());
            IStructuredDocument tempDocument = tempModel.getStructuredDocument();
            PomEdits.performOnDOMDocument(new PomEdits.OperationTuple((IDOMModel)tempModel, operation));
            TextChange change = new ChangeCreator((IFile)(!forceSave && existing ? null : file), (IDocument)document, (IDocument)tempDocument, label).createChange();
            if (forceSave) assert (change instanceof TextFileChange);
            if (forceSave && change instanceof TextFileChange var10_12) {
                textFileChange.setSaveMode(2);
            }
            TextChange textChange = change;
            return textChange;
        }
        catch (Exception exc) {
            LOG.error(Messages.PomHelper_errorCreatingChange, (Throwable)exc);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core.ui", Messages.PomHelper_errorCreatingChange, (Throwable)exc));
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public static TextChange createChange(IFile file, PomEdits.Operation operation, String label) throws CoreException {
        return PomHelper.createChange(file, operation, label, false);
    }

    public static Element createPlugin(Element parentList, String groupId, String artifactId, String version) {
        Document doc = parentList.getOwnerDocument();
        Element plug = doc.createElement("plugin");
        parentList.appendChild(plug);
        if (groupId != null) {
            PomEdits.createElementWithText(plug, "groupId", groupId);
        }
        PomEdits.createElementWithText(plug, "artifactId", artifactId);
        if (version != null) {
            PomEdits.createElementWithText(plug, "version", version);
        }
        PomEdits.format(plug);
        return plug;
    }

    public static Element createDependency(Element parentList, String groupId, String artifactId, String version) {
        Element dep = PomEdits.createElement(parentList, "dependency");
        if (groupId != null) {
            PomEdits.createElementWithText(dep, "groupId", groupId);
        }
        PomEdits.createElementWithText(dep, "artifactId", artifactId);
        if (version != null) {
            PomEdits.createElementWithText(dep, "version", version);
        }
        PomEdits.format(dep);
        return dep;
    }

    public static List<Element> findDependencies(Element node) {
        return PomEdits.findChilds(PomEdits.findChild(node, "dependencies"), "dependency");
    }

    public static Element addOrUpdateDependency(Element depsEl, String groupId, String artifactId, String version, String type, String scope, String classifier) {
        Element dep = PomEdits.findChild(depsEl, "dependency", PomEdits.childEquals("groupId", groupId), PomEdits.childEquals("artifactId", artifactId));
        if (dep == null) {
            dep = PomHelper.createDependency(depsEl, groupId, artifactId, version);
        } else if (version != null) {
            PomEdits.setText(PomEdits.getChild(dep, "version"), version);
        } else {
            PomEdits.removeChild(dep, PomEdits.findChild(dep, "version"));
        }
        if (type != null && !"jar".equals(type) && !"null".equals(type)) {
            PomEdits.setText(PomEdits.getChild(dep, "type"), type);
        } else {
            PomEdits.removeChild(dep, PomEdits.findChild(dep, "type"));
        }
        if (classifier != null) {
            PomEdits.setText(PomEdits.getChild(dep, "classifier"), classifier);
        } else {
            PomEdits.removeChild(dep, PomEdits.findChild(dep, "classifier"));
        }
        if (scope != null && !"compile".equals(scope)) {
            PomEdits.setText(PomEdits.getChild(dep, "scope"), scope);
        } else {
            PomEdits.removeChild(dep, PomEdits.findChild(dep, "scope"));
        }
        return dep;
    }
}

