/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ScriptElementImageProvider;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.ui.util.PHPElementImageDescriptor;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class PHPModelLabelProvider
extends LabelProvider
implements ILabelProvider {
    private ImageDescriptorRegistry fRegistry;
    private final int fImageFlags;
    private final long fTextFlags;
    private ScriptElementImageProvider fImageProvider;
    public static final long DEFAULT_TEXTFLAGS = ScriptElementLabels.ALL_DEFAULT;
    public static final int DEFAULT_IMAGEFLAGS = 3;

    public PHPModelLabelProvider(long textFlags, int imageFlags) {
        this.fImageFlags = imageFlags;
        this.fTextFlags = textFlags;
        this.fRegistry = null;
        this.fImageProvider = new ScriptElementImageProvider();
    }

    public PHPModelLabelProvider() {
        this(DEFAULT_TEXTFLAGS, 3);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = DLTKUIPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public Image getImage(Object element) {
        ImageDescriptor baseImage;
        if (element instanceof IModelElement && (baseImage = this.getImageDescriptor((IModelElement)element, this.fImageFlags)) != null) {
            return this.getRegistry().get(baseImage);
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor(IModelElement element, int imageFlags) {
        if (element == null) {
            return null;
        }
        ImageDescriptor baseImage = this.getBaseImageDescriptor(element, imageFlags);
        if (baseImage != null) {
            int adornmentFlags = this.getAdornmentFlags(element);
            Point size = (imageFlags & 2) != 0 ? ScriptElementImageProvider.SMALL_SIZE : ScriptElementImageProvider.BIG_SIZE;
            return new PHPElementImageDescriptor(baseImage, adornmentFlags, size);
        }
        return null;
    }

    private ImageDescriptor getBaseImageDescriptor(IModelElement element, int imageFlags) {
        if (element instanceof ISourceModule && PHPToolkitUtil.isPHPFile((ISourceModule)((ISourceModule)element))) {
            return PHPPluginImages.getImageRegistry().getDescriptor("org.eclipse.php.ui.phpfile.png");
        }
        return this.fImageProvider.getBaseImageDescriptor(element, imageFlags);
    }

    private int getAdornmentFlags(IModelElement element) {
        int adornments = 0;
        int modifiers = 0;
        if (element instanceof IMember) {
            try {
                modifiers = ((IMember)element).getFlags();
            }
            catch (ModelException e) {
                if (e.isDoesNotExist()) {
                    return modifiers;
                }
                Logger.logException((Throwable)e);
            }
        }
        try {
            if (element.getElementType() == 9 && ((IMethod)element).isConstructor()) {
                adornments |= 0x200;
            }
        }
        catch (ModelException e) {
            if (e.isDoesNotExist()) {
                return modifiers;
            }
            Logger.logException((Throwable)e);
        }
        if (PHPFlags.isAbstract((int)modifiers)) {
            adornments |= 4;
        }
        if (PHPFlags.isConstant((int)modifiers)) {
            adornments |= 2;
        } else if (PHPFlags.isFinal((int)modifiers)) {
            adornments |= 8;
        }
        if (PHPFlags.isStatic((int)modifiers)) {
            adornments |= 1;
        }
        if (PHPFlags.isDeprecated((int)modifiers)) {
            adornments |= 0x400;
        }
        return adornments;
    }

    public String getText(Object element) {
        return null;
    }
}

