/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.devhelp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.cdt.libhover.FunctionInfo;
import org.eclipse.linuxtools.cdt.libhover.LibHoverInfo;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.preferences.FuncFoundSaxException;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.preferences.LibHoverMessages;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ParseDevHelp {
    private static final String PARSING_MSG = "Libhover.Devhelp.Parsing.msg";
    private static final String PARSING_FMT_MSG = "Libhover.Devhelp.Parsing.fmt.msg";

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        startParse = System.currentTimeMillis();
        devhelpHtmlDirectory = "/usr/share/gtk-doc/html";
        p = new DevHelpParser(devhelpHtmlDirectory, false);
        dir = new File(devhelpHtmlDirectory);
        var9_5 = dir.listFiles();
        var8_6 = var9_5.length;
        var7_8 = 0;
        while (var7_8 < var8_6) {
            f = var9_5[var7_8];
            name = f.getName();
            p.parse(String.valueOf(f.getAbsolutePath()) + "/" + name + ".devhelp2", (IProgressMonitor)new NullProgressMonitor());
            ++var7_8;
        }
        endParse = System.currentTimeMillis();
        System.out.println("Parse Complete:" + (endParse - startParse));
        startSerialize = System.currentTimeMillis();
        hover = p.getLibHoverInfo();
        try {
            workspaceDir = new Path(args[1]);
            location = workspaceDir.append("org.eclipse.linuxtools.cdt.libhover/C");
            ldir = new File(location.toOSString());
            ldir.mkdir();
            location = location.append("devhelp.libhover");
            var14_17 = null;
            var15_19 = null;
            try {
                f = new FileOutputStream(location.toOSString());
                try {
                    out = new ObjectOutputStream(f);
                    try {
                        out.writeObject(hover);
                    }
                    finally {
                        if (out != null) {
                            out.close();
                        }
                    }
                    ** if (f == null) goto lbl-1000
                }
                catch (Throwable var15_20) {
                    if (var14_17 == null) {
                        var14_17 = var15_20;
                    } else if (var14_17 != var15_20) {
                        var14_17.addSuppressed(var15_20);
                    }
                    if (f != null) {
                        f.close();
                    }
                    throw var14_17;
                }
lbl-1000:
                // 1 sources

                {
                    f.close();
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            catch (Throwable var15_21) {
                if (var14_17 == null) {
                    var14_17 = var15_21;
                } else if (var14_17 != var15_21) {
                    var14_17.addSuppressed(var15_21);
                }
                throw var14_17;
            }
        }
        catch (IOException workspaceDir) {
            // empty catch block
        }
        endSerialize = System.currentTimeMillis();
        System.out.println("Parse Complete:" + (endSerialize - startSerialize));
    }

    public static class DevHelpParser {
        private String dirName;
        private LibHoverInfo libhover;
        private boolean debug;
        private FilenameComparator filenameComparator = new FilenameComparator();
        private NullEntityResolver entityResolver = new NullEntityResolver();
        private DocumentBuilderFactory factory;

        public DevHelpParser(String dirName) {
            this(dirName, false);
        }

        public DevHelpParser(String dirName, boolean debug) {
            this.dirName = dirName;
            this.libhover = new LibHoverInfo();
            this.debug = debug;
            this.factory = DocumentBuilderFactory.newInstance();
            this.factory.setValidating(false);
        }

        public LibHoverInfo getLibHoverInfo() {
            return this.libhover;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public LibHoverInfo parse(IProgressMonitor monitor) {
            try {
                IFileSystem fs = EFS.getLocalFileSystem();
                Path dirPath = new Path(this.dirName);
                IFileStore htmlDir = fs.getStore((IPath)dirPath);
                IFileStore[] files = htmlDir.childStores(0, null);
                monitor.beginTask(LibHoverMessages.getString(ParseDevHelp.PARSING_MSG), files.length);
                Arrays.sort(files, this.filenameComparator);
                int i = 0;
                while (true) {
                    if (i >= files.length) {
                        return this.libhover;
                    }
                    IFileStore file = files[i];
                    String name = file.fetchInfo().getName();
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    monitor.setTaskName(LibHoverMessages.getFormattedString(ParseDevHelp.PARSING_FMT_MSG, new String[]{name}));
                    File f = new File(dirPath.append(name).append(String.valueOf(name) + ".devhelp2").toOSString());
                    if (f.exists()) {
                        this.parse(f.getAbsolutePath(), monitor);
                    } else {
                        this.parse(dirPath.append(name).append(String.valueOf(name) + ".devhelp").toOSString(), monitor);
                    }
                    monitor.worked(1);
                    ++i;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return this.libhover;
        }

        private void parseLinks(HashMap<String, String> funcMap, String fileName, IPath path, LibHoverInfo libhover) {
            FileInputStream reader = null;
            HTMLSaxParser parser = null;
            try {
                reader = new FileInputStream(String.valueOf(path.removeLastSegments(1).toOSString()) + "/" + fileName);
                parser = new HTMLSaxParser(funcMap);
                try {
                    parser.parse(new InputSource(reader));
                }
                catch (FuncFoundSaxException funcFoundSaxException) {
                    // empty catch block
                }
                ((InputStream)reader).close();
                TreeMap<String, FunctionInfo> finfos = parser.getFunctionInfos();
                if (finfos != null) {
                    if (this.debug) {
                        System.out.println(parser.toString());
                    }
                    libhover.functions.putAll(finfos);
                }
            }
            catch (IOException finfos) {
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }

        private void parse(String fileName, IProgressMonitor monitor) {
            try {
                NamedNodeMap m;
                Node n;
                HashMap<String, HashMap<String, String>> files = new HashMap<String, HashMap<String, String>>();
                Path path = new Path(fileName);
                File f = new File(fileName);
                FileInputStream stream = new FileInputStream(f);
                DocumentBuilder builder = this.factory.newDocumentBuilder();
                builder.setEntityResolver(this.entityResolver);
                Document doc = builder.parse(stream);
                NodeList bookNodes = doc.getElementsByTagName("book");
                int x = 0;
                while (x < bookNodes.getLength()) {
                    Node n2 = bookNodes.item(x);
                    NamedNodeMap m2 = n2.getAttributes();
                    Node language = m2.getNamedItem("language");
                    if (language != null && !language.getNodeValue().equals("c")) {
                        return;
                    }
                    ++x;
                }
                if (path.getFileExtension().equals("devhelp")) {
                    NodeList nl = doc.getElementsByTagName("function");
                    int i = 0;
                    while (i < nl.getLength()) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        n = nl.item(i);
                        m = n.getAttributes();
                        Node name = m.getNamedItem("name");
                        Node link = m.getNamedItem("link");
                        if (name != null && link != null) {
                            String nameValue = name.getNodeValue();
                            if (!((nameValue = nameValue.replaceAll("\\(.*\\);+", "").trim()).contains("::") || nameValue.startsWith("enum ") || nameValue.contains("\""))) {
                                String linkValue = link.getNodeValue();
                                String[] linkParts = linkValue.split("#");
                                HashMap<String, String> funcMap = (HashMap<String, String>)files.get(linkParts[0]);
                                if (funcMap == null) {
                                    funcMap = new HashMap<String, String>();
                                    files.put(linkParts[0], funcMap);
                                }
                                funcMap.put(linkParts[1], nameValue);
                            }
                        }
                        ++i;
                    }
                } else if (path.getFileExtension().equals("devhelp2")) {
                    NodeList nl = doc.getElementsByTagName("keyword");
                    int i = 0;
                    while (i < nl.getLength()) {
                        String typeName;
                        if (monitor.isCanceled()) {
                            return;
                        }
                        n = nl.item(i);
                        m = n.getAttributes();
                        Node type = m.getNamedItem("type");
                        if (type != null && (typeName = type.getNodeValue()).equals("function")) {
                            Node name = m.getNamedItem("name");
                            Node link = m.getNamedItem("link");
                            if (name != null && link != null) {
                                String nameValue = name.getNodeValue();
                                if (!((nameValue = nameValue.replaceAll("\\(.*\\);+", "").trim()).contains("::") || nameValue.startsWith("enum ") || nameValue.contains("\""))) {
                                    String linkValue = link.getNodeValue();
                                    String[] linkParts = linkValue.split("#");
                                    HashMap<String, String> funcMap = (HashMap<String, String>)files.get(linkParts[0]);
                                    if (funcMap == null) {
                                        funcMap = new HashMap<String, String>();
                                        files.put(linkParts[0], funcMap);
                                    }
                                    funcMap.put(linkParts[1], nameValue);
                                }
                            }
                        }
                        ++i;
                    }
                }
                for (Map.Entry entry : files.entrySet()) {
                    String fname = (String)entry.getKey();
                    HashMap funcMap = (HashMap)entry.getValue();
                    this.parseLinks(funcMap, fname, (IPath)path, this.libhover);
                }
            }
            catch (FileNotFoundException files) {
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                e.printStackTrace();
            }
        }

        private static final class FilenameComparator
        implements Comparator<IFileStore> {
            private FilenameComparator() {
            }

            @Override
            public int compare(IFileStore arg0, IFileStore arg1) {
                return arg0.getName().compareToIgnoreCase(arg1.getName());
            }
        }

        private static final class NullEntityResolver
        implements EntityResolver {
            private NullEntityResolver() {
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(new StringReader(""));
            }
        }
    }

    private static class HTMLSaxParser
    extends AbstractSAXParser {
        private boolean begin;
        private boolean refsect2;
        private boolean returnType;
        private boolean protoStart;
        private boolean parmStart;
        private boolean descStart;
        private boolean rowIgnore;
        private boolean valid = true;
        private HashMap<String, String> funcs;
        private String returnValue;
        private String funcName;
        private String rowTag;
        private StringBuilder prototype = new StringBuilder();
        private StringBuilder description = new StringBuilder();
        private int divCounter;
        private int rowItemCount;
        private TreeMap<String, FunctionInfo> infos = new TreeMap();

        public HTMLSaxParser(HashMap<String, String> funcs) {
            super((XMLParserConfiguration)new HTMLConfiguration());
            this.funcs = funcs;
        }

        public void startElement(QName name, XMLAttributes a, Augmentations aug) {
            String fname;
            String mapName;
            if ("A".equals(name.rawname) && (mapName = this.funcs.get(fname = a.getValue("name"))) != null) {
                this.funcName = mapName.trim();
                if (this.funcName.endsWith("()")) {
                    this.funcName = this.funcName.replaceAll("\\(\\)", "").replaceAll("\\p{javaSpaceChar}", "");
                }
                this.begin = true;
                this.funcs.remove(fname);
                this.divCounter = this.refsect2 ? 1 : 0;
                this.refsect2 = false;
            }
            if (this.begin) {
                String type;
                if ("DIV".equals(name.rawname)) {
                    ++this.divCounter;
                }
                if (!this.descStart) {
                    if ("SPAN".equals(name.rawname)) {
                        type = a.getValue("class");
                        if (this.returnValue == null && type != null && type.equals("returnvalue")) {
                            this.returnType = true;
                        }
                    } else if ("PRE".equals(name.rawname) && (type = a.getValue("class")) != null && type.equals("programlisting")) {
                        this.returnType = true;
                    }
                }
                if (this.protoStart) {
                    if ("P".equals(name.rawname)) {
                        this.protoStart = false;
                        this.descStart = true;
                        this.description.append("<p>");
                    }
                } else if (this.descStart) {
                    if ("P".equals(name.rawname)) {
                        this.description.append("<p>");
                    } else if ("TABLE".equals(name.rawname)) {
                        this.description.append("<dl>");
                    } else if ("TR".equals(name.rawname)) {
                        this.rowItemCount = 0;
                    } else if ("TD".equals(name.rawname)) {
                        type = a.getValue("class");
                        if (type != null && type.equals("listing_lines")) {
                            this.rowIgnore = true;
                        } else {
                            this.rowIgnore = false;
                            this.rowTag = this.rowItemCount++ == 0 ? "<dt>" : "<dd>";
                            this.description.append(this.rowTag);
                        }
                    } else if ("H4".equals(name.rawname)) {
                        this.description.append("<br><br>");
                    }
                }
            } else if ("DIV".equals(name.rawname)) {
                String className = a.getValue("class");
                this.refsect2 = "refsect2".equals(className);
            }
        }

        public void endElement(QName name, Augmentations aug) {
            if (this.begin) {
                if ("DIV".equals(name.rawname)) {
                    --this.divCounter;
                    if (this.divCounter <= 0) {
                        this.begin = false;
                        this.descStart = false;
                        this.parmStart = false;
                        this.protoStart = false;
                        if (this.valid && this.returnValue != null && !this.returnValue.startsWith("#") && !this.returnValue.startsWith("typedef ")) {
                            FunctionInfo info = new FunctionInfo(this.funcName);
                            info.setReturnType(this.returnValue);
                            info.setPrototype(this.prototype.toString());
                            info.setDescription(this.description.toString());
                            this.infos.put(this.funcName, info);
                            this.description.setLength(0);
                            this.prototype.setLength(0);
                            if (this.funcs.isEmpty()) {
                                throw new FuncFoundSaxException();
                            }
                        }
                    }
                }
                if (this.descStart) {
                    if ("P".equals(name.rawname)) {
                        this.description.append("</p>");
                    } else if ("TABLE".equals(name.rawname)) {
                        this.description.append("</dl>");
                    } else if ("TR".equals(name.rawname)) {
                        this.rowItemCount = 0;
                    } else if ("TD".equals(name.rawname)) {
                        if (!this.rowIgnore) {
                            if (this.rowTag != null && this.rowTag.equals("<dt>")) {
                                this.description.append("</dt>");
                            } else {
                                this.description.append("</dd>");
                            }
                        }
                        this.rowIgnore = false;
                    } else if ("H4".equals(name.rawname)) {
                        this.description.append("</br></br>");
                    }
                }
            }
        }

        public void characters(XMLString data, Augmentations aug) {
            if (this.begin) {
                if (this.returnType) {
                    this.returnValue = "";
                    String tmp = data.toString().trim();
                    boolean completed = false;
                    if (tmp.endsWith(");")) {
                        completed = true;
                        tmp = tmp.substring(0, tmp.length() - 2);
                    }
                    String[] tokens = tmp.split("\\s+");
                    String separator = "";
                    this.protoStart = true;
                    int i = 0;
                    while (i < tokens.length) {
                        String token = tokens[i];
                        if (token.equals(this.funcName)) {
                            separator = "";
                            int j = i + 1;
                            while (j < tokens.length) {
                                String jtoken = tokens[j];
                                if (j == i + 1 && jtoken.charAt(0) == '(') {
                                    jtoken = jtoken.substring(1);
                                    this.parmStart = true;
                                    this.protoStart = false;
                                }
                                this.prototype.append(separator).append(jtoken);
                                separator = " ";
                                ++j;
                            }
                            if (!this.parmStart || !completed) break;
                            this.parmStart = false;
                            this.descStart = true;
                            break;
                        }
                        this.returnValue = String.valueOf(this.returnValue) + separator + token;
                        separator = " ";
                        ++i;
                    }
                    this.returnType = false;
                } else if (this.protoStart) {
                    String temp = data.toString().trim();
                    boolean completed = false;
                    if (temp.endsWith(");")) {
                        completed = true;
                        temp = temp.substring(0, temp.length() - 2);
                    }
                    String separator = " ";
                    while (temp.startsWith("*") || temp.startsWith("const")) {
                        if (temp.charAt(0) == '*') {
                            this.returnValue = String.valueOf(this.returnValue) + separator + "*";
                            temp = temp.substring(1).trim();
                            separator = "";
                            continue;
                        }
                        this.returnValue = String.valueOf(this.returnValue) + "const";
                        temp = temp.substring(5).trim();
                        separator = " ";
                    }
                    int index = temp.lastIndexOf(40);
                    int index2 = temp.lastIndexOf(41);
                    if (index2 < index) {
                        if (index + 1 < temp.length()) {
                            temp = temp.substring(index + 1).trim();
                            this.prototype.append(temp);
                        }
                        this.parmStart = true;
                        this.protoStart = false;
                    }
                    if (this.parmStart && completed) {
                        this.parmStart = false;
                        this.descStart = true;
                    }
                } else if (this.parmStart) {
                    String parmData = data.toString().trim();
                    int index = parmData.indexOf(41);
                    if (index >= 0) {
                        this.parmStart = false;
                        this.descStart = true;
                        parmData = parmData.substring(0, index);
                    }
                    if (this.prototype.length() == 0 && !parmData.equals(",") && !parmData.isEmpty()) {
                        parmData = " " + parmData;
                    }
                    this.prototype.append(parmData);
                } else if (this.descStart && !this.rowIgnore) {
                    this.description.append(String.valueOf(data));
                }
            }
        }

        private TreeMap<String, FunctionInfo> getFunctionInfos() {
            return this.infos;
        }

        public String toString() {
            return "funcName: <" + this.funcName + "> returnType: <" + this.returnValue + "> prototype: <" + this.prototype + "> description: " + this.description;
        }
    }
}

