/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.core;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.MethodCallExpression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.Reference;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.core.search.matching.PatternLocator;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.ast.expressions.TclExecuteExpression;
import org.eclipse.dltk.tcl.core.BasicTclMatchLocatorParser;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.extensions.IMatchLocatorExtension;
import org.eclipse.dltk.tcl.internal.core.TclExtensionManager;
import org.eclipse.dltk.tcl.internal.parser.OldTclParserUtils;

public class TclMatchLocatorParser
extends BasicTclMatchLocatorParser {
    IMatchLocatorExtension[] extensions;
    private ASTVisitor visitor = new ASTVisitor(){

        public boolean visitGeneral(ASTNode node) throws Exception {
            TclBlockExpression block;
            List ss;
            PatternLocator locator = TclMatchLocatorParser.this.getPatternLocator();
            if (node instanceof TclStatement) {
                TclStatement statement = (TclStatement)node;
                FieldDeclaration[] fields = OldTclParserUtils.returnVariableDeclarations(statement);
                int k = 0;
                while (k < fields.length) {
                    locator.match(fields[k], TclMatchLocatorParser.this.getNodeSet());
                    ++k;
                }
                TclMatchLocatorParser.this.processReferences(statement);
            } else if (node instanceof FieldDeclaration) {
                locator.match((FieldDeclaration)node, TclMatchLocatorParser.this.getNodeSet());
            } else if (node instanceof CallExpression) {
                locator.match((CallExpression)node, TclMatchLocatorParser.this.getNodeSet());
            } else if (node instanceof TclBlockExpression && (ss = (block = (TclBlockExpression)node).parseBlockSimple()) != null) {
                int slen = ss.size();
                int u = 0;
                while (u < slen) {
                    ASTNode n = (ASTNode)ss.get(u);
                    TclMatchLocatorParser.this.processReferences((TclStatement)n);
                    ++u;
                }
            }
            int i = 0;
            while (i < TclMatchLocatorParser.this.extensions.length) {
                TclMatchLocatorParser.this.extensions[i].visitGeneral(node, locator, TclMatchLocatorParser.this.getNodeSet());
                ++i;
            }
            return true;
        }

        public boolean visit(MethodDeclaration s) throws Exception {
            TclMatchLocatorParser.this.getPatternLocator().match(TclMatchLocatorParser.this.processMethod(s), TclMatchLocatorParser.this.getNodeSet());
            return true;
        }

        public boolean visit(TypeDeclaration s) throws Exception {
            TclMatchLocatorParser.this.getPatternLocator().match(TclMatchLocatorParser.this.processType(s), TclMatchLocatorParser.this.getNodeSet());
            return true;
        }
    };

    public TclMatchLocatorParser(MatchLocator locator) {
        super(locator);
        this.extensions = TclExtensionManager.getDefault().getMatchLocatorExtensions();
    }

    @Override
    protected void processStatement(ASTNode node) {
        block3: {
            if (node != null) {
                try {
                    node.traverse(this.visitor);
                }
                catch (Exception e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    protected void processReferences(TclStatement statement) {
        Expression commandId = statement.getAt(0);
        PatternLocator locator = this.getPatternLocator();
        if (commandId != null && commandId instanceof SimpleReference) {
            String name = ((SimpleReference)commandId).getName();
            if (name.startsWith("::")) {
                name = name.substring(2);
            }
            if (!kwMap.containsKey(name)) {
                String[] ns = TclParseUtil.tclSplit(name);
                int i = 0;
                while (i < ns.length) {
                    if (ns[i].length() > 0) {
                        if (i == ns.length - 1) {
                            String namespace = null;
                            int pos = name.lastIndexOf("::");
                            if (pos != -1 && (namespace = name.substring(0, pos)).startsWith("::")) {
                                namespace = namespace.substring(2);
                            }
                            MethodCallExpression node = new MethodCallExpression(commandId.sourceStart(), commandId.sourceEnd(), null, ns[i], null){

                                public boolean equals(Object obj) {
                                    if (obj == this) {
                                        return true;
                                    }
                                    if (obj instanceof ASTNode) {
                                        ASTNode s = (ASTNode)obj;
                                        if (s.sourceEnd() < 0 || s.sourceStart() < 0) {
                                            return false;
                                        }
                                        return this.sourceStart() == s.sourceStart() && this.sourceEnd() == s.sourceEnd();
                                    }
                                    return false;
                                }

                                public int hashCode() {
                                    return this.sourceEnd() * 1001 + this.sourceEnd();
                                }
                            };
                            node.setDeclaringTypeName(namespace);
                            locator.match((CallExpression)node, this.getNodeSet());
                        } else {
                            locator.match(new TypeReference(commandId.sourceStart(), commandId.sourceEnd(), ns[i]){

                                public boolean equals(Object obj) {
                                    if (obj == this) {
                                        return true;
                                    }
                                    if (obj instanceof ASTNode) {
                                        ASTNode s = (ASTNode)obj;
                                        if (s.sourceEnd() < 0 || s.sourceStart() < 0) {
                                            return false;
                                        }
                                        return this.sourceStart() == s.sourceStart() && this.sourceEnd() == s.sourceEnd();
                                    }
                                    return false;
                                }

                                public int hashCode() {
                                    return this.sourceEnd() * 1001 + this.sourceEnd();
                                }
                            }, this.getNodeSet());
                        }
                    }
                    ++i;
                }
            }
        }
        int j = 1;
        while (j < statement.getCount()) {
            SimpleReference ref;
            String name;
            Expression st = statement.getAt(j);
            if (st instanceof TclExecuteExpression) {
                TclExecuteExpression expr = (TclExecuteExpression)st;
                List exprs = expr.parseExpression();
                int i = 0;
                while (i < exprs.size()) {
                    if (exprs.get(i) instanceof TclStatement) {
                        this.processReferences((TclStatement)((Object)exprs.get(i)));
                    }
                    ++i;
                }
            } else if (st instanceof StringLiteral) {
                int pos = 0;
                StringLiteral literal = (StringLiteral)st;
                String value = literal.getValue();
                pos = value.indexOf("$");
                while (pos != -1) {
                    SimpleReference ref2 = OldTclParserUtils.findVariableFromString(literal, pos);
                    if (ref2 != null) {
                        ref2.setName(ref2.getName().substring(1));
                        ref2.setEnd(ref2.sourceEnd() - 1);
                        locator.match((Reference)ref2, this.getNodeSet());
                        pos += ref2.getName().length();
                    }
                    pos = value.indexOf("$", pos + 1);
                }
            } else if (st instanceof SimpleReference && (name = (ref = (SimpleReference)st).getName()).startsWith("$")) {
                ref.setName(name.substring(1));
                ref.setEnd(ref.sourceEnd() - 1);
                locator.match((Reference)ref, this.getNodeSet());
            }
            ++j;
        }
    }
}

