/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.internal.core.util.PDEJavaHelper;
import org.eclipse.pde.internal.core.util.VMUtil;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.ContentPage;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationPage;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.TemplateListSelectionPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PluginContentPage
extends ContentPage {
    private Text fClassText;
    protected Button fGenerateActivator;
    protected Button fUIPlugin;
    private Label fClassLabel;
    private Label fEELabel;
    private Button fExeEnvButton;
    private Combo fEEChoice;
    private Group fRCPGroup;
    protected Button fYesButton;
    protected Button fNoButton;
    private Button fApiAnalysisButton;
    private static final String S_GENERATE_ACTIVATOR = "generatePluginActivator";
    private static final String S_UI_PLUGIN = "uiPlugin";
    private static final String S_RCP_PLUGIN = "rcpPlugin";
    private static final String S_API_ANALYSIS = "apiAnalysis";
    protected static final int P_CLASS_GROUP = 2;
    private static final String NO_EXECUTION_ENVIRONMENT = PDEUIMessages.PluginContentPage_noEE;
    private ModifyListener classListener = e -> {
        if (this.fInitialized) {
            this.fChangedGroups |= 2;
        }
        this.validatePage();
    };

    public PluginContentPage(String pageName, IProjectProvider provider, NewProjectCreationPage page, AbstractFieldData data) {
        super(pageName, provider, page, data);
        this.setTitle(PDEUIMessages.ContentPage_title);
        this.setDescription(PDEUIMessages.ContentPage_desc);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.createPluginPropertiesGroup(container);
        this.createPluginClassGroup(container);
        this.createRCPQuestion(container, 2);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.new_project_required_data");
    }

    private void createPluginPropertiesGroup(Composite container) {
        Group propertiesGroup = SWTFactory.createGroup(container, PDEUIMessages.ContentPage_pGroup, 3, 1, 768);
        Label label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.ContentPage_pid);
        this.fIdText = this.createText((Composite)propertiesGroup, this.propertiesListener, 2);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.ContentPage_pversion);
        this.fVersionText = this.createText((Composite)propertiesGroup, this.propertiesListener, 2);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.ContentPage_pname);
        this.fNameText = this.createText((Composite)propertiesGroup, this.propertiesListener, 2);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.ContentPage_pprovider);
        this.fProviderCombo = this.createProviderCombo((Composite)propertiesGroup, this.propertiesListener, 2);
        this.createExecutionEnvironmentControls((Composite)propertiesGroup);
    }

    private void createExecutionEnvironmentControls(Composite container) {
        this.fEELabel = new Label(container, 0);
        this.fEELabel.setText(PDEUIMessages.NewProjectCreationPage_executionEnvironments_label);
        this.fEEChoice = new Combo(container, 2060);
        this.fEEChoice.setLayoutData((Object)new GridData(768));
        IExecutionEnvironment[] exeEnvs = VMUtil.getExecutionEnvironments();
        ArrayList<String> availableEEs = new ArrayList<String>();
        availableEEs.add(NO_EXECUTION_ENVIRONMENT);
        IExecutionEnvironment[] iExecutionEnvironmentArray = exeEnvs;
        int n = exeEnvs.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutionEnvironment exeEnv = iExecutionEnvironmentArray[n2];
            availableEEs.add(exeEnv.getId());
            ++n2;
        }
        this.fEEChoice.setItems(availableEEs.toArray(new String[availableEEs.size()]));
        this.fEEChoice.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.validatePage()));
        IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
        String[] EEChoices = this.fEEChoice.getItems();
        int i = 0;
        while (i < EEChoices.length) {
            if (!EEChoices[i].equals(NO_EXECUTION_ENVIRONMENT) && VMUtil.getExecutionEnvironment((String)EEChoices[i]).isStrictlyCompatible(defaultVM)) {
                this.fEEChoice.select(i);
                break;
            }
            ++i;
        }
        int selectionIndex = this.fEEChoice.getSelectionIndex();
        if (selectionIndex == -1) {
            int i2 = EEChoices.length - 1;
            while (i2 >= 0) {
                List<IVMInstall> vmList;
                IVMInstall[] vm;
                if (!EEChoices[i2].equals(NO_EXECUTION_ENVIRONMENT) && (vm = VMUtil.getExecutionEnvironment((String)EEChoices[i2]).getCompatibleVMs()) != null && vm.length != 0 && (vmList = Arrays.asList(vm)).contains(defaultVM)) {
                    this.fEEChoice.select(i2);
                    break;
                }
                --i2;
            }
        }
        this.fExeEnvButton = new Button(container, 8);
        this.fExeEnvButton.setLayoutData((Object)new GridData());
        this.fExeEnvButton.setText(PDEUIMessages.NewProjectCreationPage_environmentsButton);
        this.fExeEnvButton.addListener(13, event -> {
            int n = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"org.eclipse.jdt.debug.ui.jreProfiles", (String[])new String[]{"org.eclipse.jdt.debug.ui.jreProfiles"}, null).open();
        });
    }

    protected void createPluginClassGroup(Composite container) {
        Group classGroup = SWTFactory.createGroup(container, PDEUIMessages.ContentPage_pClassGroup, 2, 1, 768);
        IDialogSettings settings = this.getDialogSettings();
        boolean generateActivator = settings == null ? null : Boolean.valueOf(settings.getBoolean(S_GENERATE_ACTIVATOR));
        this.fGenerateActivator = SWTFactory.createCheckButton((Composite)classGroup, PDEUIMessages.ContentPage_generate, null, generateActivator, 2);
        this.fGenerateActivator.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.fClassLabel.setEnabled(this.fGenerateActivator.getSelection());
            this.fClassText.setEnabled(this.fGenerateActivator.getSelection());
            this.updateData();
            this.validatePage();
        }));
        this.fClassLabel = new Label((Composite)classGroup, 0);
        this.fClassLabel.setText(PDEUIMessages.ContentPage_classname);
        GridData gd = new GridData();
        gd.horizontalIndent = 20;
        this.fClassLabel.setLayoutData((Object)gd);
        this.fClassText = this.createText((Composite)classGroup, this.classListener);
        this.fUIPlugin = SWTFactory.createCheckButton((Composite)classGroup, PDEUIMessages.ContentPage_uicontribution, null, settings != null ? !settings.getBoolean(S_UI_PLUGIN) : true, 2);
        this.fUIPlugin.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.updateData();
            this.validatePage();
        }));
        this.fApiAnalysisButton = SWTFactory.createCheckButton((Composite)classGroup, PDEUIMessages.PluginContentPage_enable_api_analysis, null, false, 2);
        this.fApiAnalysisButton.setSelection(settings != null ? settings.getBoolean(S_API_ANALYSIS) : false);
        this.fApiAnalysisButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.updateData();
            this.validatePage();
        }));
    }

    @Override
    public void updateData() {
        super.updateData();
        PluginFieldData data = (PluginFieldData)this.fData;
        data.setClassname(this.fClassText.getText().trim());
        data.setUIPlugin(this.fUIPlugin.getSelection());
        data.setDoGenerateClass(this.fGenerateActivator.getSelection());
        data.setRCPApplicationPlugin(!this.fData.isSimple() && !this.isPureOSGi() && this.fYesButton.getSelection());
        data.setEnableAPITooling(this.fApiAnalysisButton.isEnabled() && this.fApiAnalysisButton.getSelection());
        if (this.fEEChoice.isEnabled() && !this.fEEChoice.getText().equals(NO_EXECUTION_ENVIRONMENT)) {
            this.fData.setExecutionEnvironment(this.fEEChoice.getText().trim());
        } else {
            this.fData.setExecutionEnvironment(null);
        }
    }

    protected void createRCPQuestion(Composite parent, int horizontalSpan) {
        this.fRCPGroup = SWTFactory.createGroup(parent, PDEUIMessages.PluginContentPage_rcpGroup, 2, 1, 768);
        Composite comp = new Composite((Composite)this.fRCPGroup, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = horizontalSpan;
        comp.setLayoutData((Object)gd);
        Label label = new Label(comp, 0);
        label.setText(PDEUIMessages.PluginContentPage_appQuestion);
        label.setLayoutData((Object)new GridData(768));
        IDialogSettings settings = this.getDialogSettings();
        boolean rcpApp = settings != null ? settings.getBoolean(S_RCP_PLUGIN) : false;
        this.fYesButton = new Button(comp, 16);
        this.fYesButton.setText(PDEUIMessages.PluginContentPage_yes);
        this.fYesButton.setSelection(rcpApp);
        gd = new GridData();
        gd.widthHint = SWTFactory.getButtonWidthHint(this.fYesButton, 50);
        this.fYesButton.setLayoutData((Object)gd);
        this.fYesButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.updateData();
            this.getContainer().updateButtons();
        }));
        this.fNoButton = new Button(comp, 16);
        this.fNoButton.setText(PDEUIMessages.PluginContentPage_no);
        this.fNoButton.setSelection(!rcpApp);
        gd = new GridData();
        gd.widthHint = SWTFactory.getButtonWidthHint(this.fNoButton, 50);
        this.fNoButton.setLayoutData((Object)gd);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.fMainPage.updateData();
            boolean wasGenActivatorEnabled = this.fGenerateActivator.isEnabled();
            this.fGenerateActivator.setEnabled(!this.fData.isSimple());
            if (!this.fGenerateActivator.isEnabled()) {
                this.fGenerateActivator.setSelection(false);
            } else if (!wasGenActivatorEnabled) {
                this.fGenerateActivator.setSelection(true);
            }
            this.fClassLabel.setEnabled(!this.fData.isSimple() && this.fGenerateActivator.getSelection());
            this.fClassText.setEnabled(!this.fData.isSimple() && this.fGenerateActivator.getSelection());
            boolean wasUIPluginEnabled = this.fUIPlugin.isEnabled();
            this.fUIPlugin.setEnabled(!this.fData.isSimple() && !this.isPureOSGi());
            if (!this.fUIPlugin.isEnabled()) {
                this.fUIPlugin.setSelection(false);
            } else if (!wasUIPluginEnabled) {
                this.fUIPlugin.setSelection(true);
            }
            if ((this.fChangedGroups & 2) == 0) {
                int oldfChanged = this.fChangedGroups;
                this.fClassText.setText(String.valueOf(this.computeId().replaceAll("-", "_").toLowerCase(Locale.ENGLISH)) + ".Activator");
                this.fChangedGroups = oldfChanged;
            }
            boolean allowEESelection = !this.fData.isSimple() && this.fData.hasBundleStructure();
            this.fEELabel.setEnabled(allowEESelection);
            this.fEEChoice.setEnabled(allowEESelection);
            this.fExeEnvButton.setEnabled(allowEESelection);
            this.fApiAnalysisButton.setEnabled(allowEESelection);
            this.fRCPGroup.setVisible(!this.fData.isSimple() && !this.isPureOSGi());
        }
        super.setVisible(visible);
    }

    private boolean isPureOSGi() {
        return ((PluginFieldData)this.fData).getOSGiFramework() != null;
    }

    @Override
    protected void validatePage() {
        String errorMessage = this.validateProperties();
        if (errorMessage == null && this.fGenerateActivator.getSelection()) {
            IStatus status = JavaConventions.validateJavaTypeName((String)this.fClassText.getText().trim(), (String)PDEJavaHelper.getJavaSourceLevel(null), (String)PDEJavaHelper.getJavaComplianceLevel(null));
            if (status.getSeverity() == 4) {
                errorMessage = status.getMessage();
            } else if (status.getSeverity() == 2) {
                this.setMessage(status.getMessage(), 2);
            }
        }
        if (errorMessage == null) {
            IExecutionEnvironment ee;
            String eeid = this.fEEChoice.getText();
            if (this.fEEChoice.isEnabled() && (ee = VMUtil.getExecutionEnvironment((String)eeid)) != null && ee.getCompatibleVMs().length == 0) {
                this.setMessage(PDEUIMessages.NewProjectCreationPage_invalidEE, 2);
            }
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    @Override
    public void saveSettings(IDialogSettings settings) {
        super.saveSettings(settings);
        if (this.fGenerateActivator.isEnabled()) {
            settings.put(S_GENERATE_ACTIVATOR, this.fGenerateActivator.getSelection());
        }
        if (this.fUIPlugin.isEnabled()) {
            settings.put(S_UI_PLUGIN, !this.fUIPlugin.getSelection());
        }
        if (this.fApiAnalysisButton.isEnabled()) {
            settings.put(S_API_ANALYSIS, this.fApiAnalysisButton.getSelection());
        }
        settings.put(S_RCP_PLUGIN, this.fYesButton.getSelection());
    }

    public boolean canFlipToNextPage() {
        if (this.getNextPage() instanceof TemplateListSelectionPage) {
            TemplateListSelectionPage templatePage = (TemplateListSelectionPage)this.getNextPage();
            return super.canFlipToNextPage() && templatePage.isAnyTemplateAvailable();
        }
        return super.canFlipToNextPage();
    }
}

