/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.ui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Paths;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.vagrant.ui.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.vagrant.ui";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        String LAUNCH_ID = "firstLaunch";
        boolean firstLaunch = InstanceScope.INSTANCE.getNode(PLUGIN_ID).getBoolean("firstLaunch", true);
        if ("linux".equals(Platform.getOS()) && firstLaunch) {
            Thread t = new Thread(() -> {
                File[] libvirtFiles;
                File polkitDir = Paths.get("/", "usr", "share", "polkit-1", "actions").toFile();
                if (polkitDir.exists() && (libvirtFiles = polkitDir.listFiles((dir, name) -> name.matches("org\\.libvirt.*\\.policy"))).length > 0) {
                    Display.getDefault().syncExec(() -> MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.Activator_additional_configuration_title, (String)Messages.Activator_additional_configuration_msg));
                }
            });
            t.start();
            InstanceScope.INSTANCE.getNode(PLUGIN_ID).putBoolean("firstLaunch", false);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        Activator.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        Activator.log((IStatus)new Status(4, PLUGIN_ID, 4, message, null));
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, PLUGIN_ID, 0, e.getMessage(), e);
        Activator.log(status);
    }
}

