/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.actions;

import org.eclipse.datatools.sqltools.sql.parser.ast.Node;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.Messages;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;

class CopyToClipboardAction
extends SelectionDispatchAction {
    private static final int _MAX_REPEAT_COUNT = 10;
    private final Clipboard _fClipboard;
    private SelectionDispatchAction _fPasteAction;

    public CopyToClipboardAction(IWorkbenchSite site, Clipboard clipboard, SelectionDispatchAction pasteAction) {
        super(site);
        this.setText(Messages.CopyAction_label);
        this.setToolTipText(Messages.CopyAction_tooltip);
        this._fClipboard = clipboard;
        this._fPasteAction = pasteAction;
        ISharedImages workbenchImages = PlatformUI.getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IAbstractTextEditorHelpContextIds.COPY_ACTION);
        this.update(this.getSelection());
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canEnable(selection));
    }

    private boolean canEnable(IStructuredSelection selection) {
        return selection.size() == 1 && selection.getFirstElement() instanceof Node;
    }

    @Override
    public void run(IStructuredSelection selection) {
        if (selection.size() > 1 || selection.size() <= 0) {
            return;
        }
        String text = "";
        if (!(selection.getFirstElement() instanceof Node)) {
            return;
        }
        text = ((Node)selection.getFirstElement()).getSQLText();
        this.copyToClipboard(text, 0);
        if (this._fPasteAction != null && this._fPasteAction.getSelection() != null) {
            this._fPasteAction.update(this._fPasteAction.getSelection());
        }
    }

    private void copyToClipboard(String text, int repeatCount) {
        block3: {
            try {
                this._fClipboard.setContents((Object[])new String[]{text}, new Transfer[]{TextTransfer.getInstance()});
            }
            catch (SWTError e) {
                if (e.code != 2002 || repeatCount >= 10) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.CopyToClipboard_error_title, (String)Messages.CopyToClipboard_error_message)) break block3;
                this.copyToClipboard(text, repeatCount + 1);
            }
        }
    }
}

