/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.jdt.ui;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.IDialogFieldListener;
import org.eclipse.wb.internal.core.utils.jdt.ui.IPackageRootChangeListener;
import org.eclipse.wb.internal.core.utils.jdt.ui.IPackageRootFilter;
import org.eclipse.wb.internal.core.utils.jdt.ui.PackageRootSelectionDialogField;
import org.eclipse.wb.internal.core.utils.jdt.ui.PackageSelectionDialogField;
import org.eclipse.wb.internal.core.utils.ui.PixelConverter;

public class PackageRootAndPackageSelectionDialogField
extends DialogField {
    private final int m_textFieldWidth;
    private final PackageRootSelectionDialogField m_rootField;
    private final PackageSelectionDialogField m_packageField;
    private boolean m_dialogFieldChanging;
    private final IDialogFieldListener m_validateListener = new IDialogFieldListener(){

        public void dialogFieldChanged(DialogField field) {
            if (!PackageRootAndPackageSelectionDialogField.this.m_dialogFieldChanging) {
                PackageRootAndPackageSelectionDialogField.this.dialogFieldChanged();
            }
        }
    };
    private PixelConverter m_pixelConverter;

    public PackageRootAndPackageSelectionDialogField(int textFieldWidth, String rootLabel, String rootButtonLabel, String packageLabel, String packageButtonLabel) {
        this.m_textFieldWidth = textFieldWidth;
        this.m_rootField = PackageRootSelectionDialogField.create(rootLabel, rootButtonLabel);
        this.m_rootField.setUpdateListener(this.m_validateListener);
        this.m_rootField.setListener(new IPackageRootChangeListener(){

            public void rootChanged(IPackageFragmentRoot newRoot) {
                PackageRootAndPackageSelectionDialogField.this.m_packageField.setRoot(PackageRootAndPackageSelectionDialogField.this.m_rootField.getRoot());
            }
        });
        this.m_packageField = PackageSelectionDialogField.create(packageLabel, packageButtonLabel);
        this.m_packageField.setUpdateListener(this.m_validateListener);
    }

    public void setPackageRootFilter(IPackageRootFilter packageRootFilter) {
        this.m_rootField.setPackageRootFilter(packageRootFilter);
    }

    public void setCompilationUnit(ICompilationUnit compilationUnit) {
        this.m_dialogFieldChanging = true;
        try {
            this.m_rootField.setCompilationUnit(compilationUnit);
            this.m_packageField.setCompilationUnit(compilationUnit);
        }
        finally {
            this.m_dialogFieldChanging = false;
        }
        this.dialogFieldChanged();
    }

    public IPackageFragmentRoot getRoot() {
        return this.m_rootField.getRoot();
    }

    public void setRoot(IPackageFragmentRoot root) {
        this.m_rootField.setRoot(root);
    }

    public IPackageFragment getPackage() {
        return this.m_packageField.getPackage();
    }

    public void setPackage(IPackageFragment pkg) {
        if (pkg != null) {
            this.m_packageField.setPackage(pkg);
            this.m_rootField.setRoot((IPackageFragmentRoot)pkg.getAncestor(3));
        } else {
            this.m_packageField.setPackage(null);
            this.m_rootField.setRoot(null);
        }
    }

    public int getNumberOfControls() {
        return 1;
    }

    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        this.m_pixelConverter = new PixelConverter((Control)parent);
        this.m_rootField.doFillIntoGrid(parent, nColumns);
        this.m_rootField.getTextControl(null).setLayoutData((Object)this.createDataForText());
        this.m_packageField.doFillIntoGrid(parent, nColumns);
        this.m_packageField.getTextControl(null).setLayoutData((Object)this.createDataForText());
        return null;
    }

    private GridData createDataForText() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.widthHint = this.m_pixelConverter.convertWidthInCharsToPixels(this.m_textFieldWidth);
        return gridData;
    }
}

